/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.evict;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.prepared.CacheEntry;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import org.smartparam.engine.core.prepared.PreparedParameter;
import pl.decerto.hyperon.runtime.evict.IntervalParser;
import pl.decerto.hyperon.runtime.model.Parameter;
import pl.decerto.hyperon.runtime.utils.Clock;
import pl.decerto.hyperon.runtime.utils.SystemClock;

public class ParamEvictor {
    private static final Logger log = LoggerFactory.getLogger(ParamEvictor.class);
    private static final long HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final int SECOND_IN_MILLIS = 1000;
    private final PreparedParamCache indexCache;
    private final Clock clock;

    public ParamEvictor(PreparedParamCache indexCache) {
        this.indexCache = indexCache;
        this.clock = new SystemClock();
    }

    public ParamEvictor(PreparedParamCache indexCache, Clock clock) {
        this.indexCache = indexCache;
        this.clock = clock;
    }

    public void evict() {
        log.trace("starting parameter eviction");
        List<CacheEntry<PreparedParameter>> cached = this.indexCache.list();
        log.trace("fetched {} cached parameters", (Object)cached.size());
        for (CacheEntry<PreparedParameter> e : cached) {
            if (Thread.currentThread().isInterrupted()) {
                log.warn("thread interrupted, stopping eviction");
                return;
            }
            PreparedParameter pp = e.getValue();
            if (!this.isExpired(pp)) continue;
            log.debug("in-mem index [{}] expired, invalidating ({})...", (Object)pp.getName(), (Object)pp.getId());
            this.indexCache.invalidate(pp.getId());
        }
        log.trace("parameter eviction finished");
    }

    private Parameter getParameterMetadata(PreparedParameter pp) {
        return (Parameter)pp.getMetadata();
    }

    private boolean isExpired(PreparedParameter pp) {
        long timeElapsed;
        Parameter p = this.getParameterMetadata(pp);
        if (!p.isAutoRefresh()) {
            return false;
        }
        String periodText = p.getAutoRefreshPeriod();
        log.trace("checking parameter {} with auto-refresh period: {}", (Object)p.getName(), (Object)periodText);
        long ttl = IntervalParser.parse(periodText);
        if (!this.isTTLValid(ttl)) {
            ttl = HOUR;
        }
        return (timeElapsed = this.clock.getTime() - p.getLoadedAtMillis()) >= ttl;
    }

    private boolean isTTLValid(long ttl) {
        return ttl >= 1000L;
    }
}

