/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.decoder;

import org.smartparam.engine.core.decoder.ValueDecoder;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.decoder.CascadeDecoder;
import pl.decerto.hyperon.runtime.model.MpParameterEntry;
import pl.decerto.hyperon.runtime.model.Parameter;
import pl.decerto.hyperon.runtime.model.ParameterLevel;

public class MpDecodingStrategy {
    private HyperonEngine engine;

    public MpDecodingStrategy(HyperonEngine engine) {
        this.engine = engine;
    }

    public ValueDecoder createCascadeDecoder() {
        return new CascadeDecoder(this.engine);
    }

    public void detectCascadingRefs(Parameter p, MpParameterEntry entry) {
        int inputCnt = p.getInputLevels();
        int levelCnt = p.getLevelCount();
        String[] cells = entry.getLevels();
        for (int i = inputCnt; i < levelCnt; ++i) {
            ParameterLevel out = p.getLevel(i);
            if (out.getValueDecoder() != null || !this.hasRef(cells[i], out)) continue;
            out.setValueDecoder(this.createCascadeDecoder());
        }
    }

    private boolean hasRef(String cell, ParameterLevel out) {
        if (cell != null) {
            if (this.isValueBlob(cell, out)) {
                return true;
            }
            if (this.isValueFunctionOrParameter(cell)) {
                return (cell = cell.trim()).startsWith("$f ") || cell.startsWith("$p ");
            }
        }
        return false;
    }

    private boolean isValueFunctionOrParameter(String cell) {
        return cell.length() > 3 && cell.indexOf(36) >= 0;
    }

    private boolean isValueBlob(String cell, ParameterLevel out) {
        return out.isExternal() && cell.indexOf(64) == 0;
    }

    public boolean hasEngineConfigured() {
        return this.engine != null;
    }

    public MpDecodingStrategy() {
    }

    public void setEngine(HyperonEngine engine) {
        this.engine = engine;
    }
}

