/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core;

import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.core.versioninterceptor.VersionInterceptor;
import pl.decerto.hyperon.runtime.decoder.FunctionCascadeParser;
import pl.decerto.hyperon.runtime.decoder.ParamCascadeParser;
import pl.decerto.hyperon.runtime.model.Type;

class DigestElementCodeProcessor {
    private final VersionInterceptor versionInterceptor;

    String preprocess(Type type, String elementCode) {
        switch (type) {
            case PARAMETER: {
                return this.preprocessParameter(elementCode);
            }
            case FUNCTION: {
                return this.preprocessFunction(elementCode);
            }
        }
        return elementCode;
    }

    private String preprocessParameter(String elementCode) {
        if (StringUtils.startsWith((CharSequence)elementCode, (CharSequence)"$p")) {
            elementCode = StringUtils.substring((String)elementCode, (int)3);
        }
        if (elementCode.contains("[")) {
            ParamCascadeParser parser = new ParamCascadeParser();
            elementCode = parser.parse(elementCode).getParamCode();
        }
        return this.versionInterceptor.decorateParameterUid(elementCode);
    }

    private String preprocessFunction(String elementCode) {
        if (StringUtils.startsWith((CharSequence)elementCode, (CharSequence)"$f")) {
            elementCode = StringUtils.substring((String)elementCode, (int)3);
        }
        if (elementCode.contains("(") || elementCode.contains("[")) {
            FunctionCascadeParser parser = new FunctionCascadeParser();
            elementCode = parser.parse(elementCode).getFunctionCode();
        }
        return this.versionInterceptor.decorateFunctionUid(elementCode);
    }

    public DigestElementCodeProcessor(VersionInterceptor versionInterceptor) {
        this.versionInterceptor = versionInterceptor;
    }
}

