/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.smartparam.engine.annotated.annotations.ParamType;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.types.number.NumberHolder;
import org.smartparam.engine.util.EngineUtil;

@ParamType(value="number")
public class NumberType
implements Type<NumberHolder> {
    @Override
    public String encode(NumberHolder value) {
        return value.getString();
    }

    @Override
    public NumberHolder decode(String text) {
        BigDecimal value = EngineUtil.hasText(text) ? this.parse(text) : null;
        return new NumberHolder(value);
    }

    @Override
    public NumberHolder convert(Object obj) {
        if (obj instanceof Number) {
            BigDecimal result;
            Number n = (Number)obj;
            if (n instanceof Double || n instanceof Float) {
                result = BigDecimal.valueOf(n.doubleValue()).stripTrailingZeros();
                if (result.scale() < 0) {
                    result = result.setScale(0, RoundingMode.UNNECESSARY);
                }
            } else {
                result = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof BigInteger ? new BigDecimal((BigInteger)n) : new BigDecimal(n.longValue()));
            }
            return new NumberHolder(result);
        }
        if (obj == null) {
            return new NumberHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public NumberHolder[] newArray(int size) {
        return new NumberHolder[size];
    }

    private BigDecimal parse(String str) {
        return new BigDecimal(EngineUtil.trimAllWhitespace(str).replace(',', '.'));
    }
}

