/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.date;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public abstract class AbstractDateParserChain<T> {
    private AbstractDateParserChain next;
    private final DateTimeFormatter formatter;

    public T parse(String text) {
        try {
            return this.doParse(text, this.formatter);
        }
        catch (DateTimeParseException e) {
            return this.nextOrThrow(text, e);
        }
    }

    protected abstract T doParse(String var1, DateTimeFormatter var2);

    private T nextOrThrow(String text, DateTimeParseException e) {
        if (this.next != null) {
            return this.next.parse(text);
        }
        throw new IllegalArgumentException("Cannot parse date string [" + text + "]", e);
    }

    public void setNext(AbstractDateParserChain next) {
        this.next = next;
    }

    public AbstractDateParserChain(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }
}

