/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.bool;

import org.smartparam.engine.annotated.annotations.ParamType;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.types.bool.BooleanHolder;
import org.smartparam.engine.util.EngineUtil;

@ParamType(value="boolean")
public class BooleanType
implements Type<BooleanHolder> {
    @Override
    public String encode(BooleanHolder holder) {
        return String.valueOf(holder.getBoolean());
    }

    @Override
    public BooleanHolder decode(String text) {
        Boolean value = EngineUtil.hasText(text) ? this.parse(text) : null;
        return new BooleanHolder(value);
    }

    @Override
    public BooleanHolder convert(Object obj) {
        if (obj instanceof Boolean) {
            return new BooleanHolder((Boolean)obj);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        if (obj == null) {
            return new BooleanHolder(null);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public BooleanHolder[] newArray(int size) {
        return new BooleanHolder[size];
    }

    private Boolean parse(String text) {
        return Boolean.valueOf(text);
    }
}

