/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.prepared;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.smartparam.engine.core.index.LevelIndex;
import org.smartparam.engine.core.parameter.Parameter;
import org.smartparam.engine.core.prepared.PreparedEntry;
import org.smartparam.engine.core.prepared.PreparedLevel;

public class PreparedParameter {
    private final int id;
    private final String name;
    private final PreparedLevel[] levels;
    private LevelIndex<PreparedEntry> index;
    private final int inputLevelsCount;
    private final boolean nullable;
    private final boolean cacheable;
    private final char arraySeparator;
    private Map<String, Integer> levelNameMap = new HashMap<String, Integer>();
    private Object metadata;

    public PreparedParameter(Parameter parameter, PreparedLevel[] levels) {
        this.id = parameter.getId();
        this.name = parameter.getName();
        this.inputLevelsCount = parameter.getInputLevels();
        this.nullable = parameter.isNullable();
        this.cacheable = parameter.isCacheable();
        this.arraySeparator = parameter.getArraySeparator();
        this.levels = levels;
    }

    public int getLevelCount() {
        return this.levels != null ? this.levels.length : 0;
    }

    public boolean isNotNull() {
        return !this.isNullable();
    }

    public void setLevelNameMap(Map<String, Integer> levelNameMap) {
        this.levelNameMap = Collections.unmodifiableMap(new HashMap<String, Integer>(levelNameMap));
    }

    private int getOutputLevelsCount() {
        return this.getLevelCount() - this.getInputLevelsCount();
    }

    public String toString() {
        return "PP#" + this.id + "[" + this.name + ", levels=" + this.getInputLevelsCount() + "/" + this.getOutputLevelsCount() + (this.nullable ? ", nullable" : ", notnull") + (this.cacheable ? ", in-mem" : ", no-mem") + "]";
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PreparedLevel[] getLevels() {
        return this.levels;
    }

    public LevelIndex<PreparedEntry> getIndex() {
        return this.index;
    }

    public int getInputLevelsCount() {
        return this.inputLevelsCount;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public char getArraySeparator() {
        return this.arraySeparator;
    }

    public Map<String, Integer> getLevelNameMap() {
        return this.levelNameMap;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setIndex(LevelIndex<PreparedEntry> index) {
        this.index = index;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }
}

