/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.annotated.repository;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.smartparam.engine.annotated.RepositoryObjectKey;
import org.smartparam.engine.annotated.annotations.ParamFunctionRepository;
import org.smartparam.engine.annotated.repository.TypeScanningRepository;
import org.smartparam.engine.annotated.scanner.TypeScanner;
import org.smartparam.engine.config.initialization.ComponentInitializerRunner;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.function.FunctionProvider;
import org.smartparam.engine.core.function.FunctionRepository;
import org.smartparam.engine.core.function.UnknownFunctionException;
import org.smartparam.engine.core.repository.MapRepository;

public class ScanningFunctionProvider
implements FunctionProvider,
TypeScanningRepository {
    private final MapRepository<FunctionRepository> innerRepository = new MapRepository(FunctionRepository.class, new TreeMap());
    private final FunctionCache functionCache;

    public ScanningFunctionProvider(FunctionCache functionCache) {
        this.functionCache = functionCache;
    }

    @Override
    public void scanAnnotations(TypeScanner scanner, ComponentInitializerRunner componentInitializerRunner) {
        Map repositories = scanner.scanTypes(ParamFunctionRepository.class);
        componentInitializerRunner.runInitializersOnList(repositories.values());
        this.innerRepository.registerAll(repositories);
    }

    @Override
    public void register(String type, int order, FunctionRepository repository) {
        RepositoryObjectKey objectKey = new RepositoryObjectKey(type, order);
        this.innerRepository.registerUnique(objectKey, repository);
    }

    @Override
    public Map<String, FunctionRepository> registeredItems() {
        return this.innerRepository.getItemsOrdered();
    }

    @Override
    public void registerAll(Map<String, FunctionRepository> items) {
        this.innerRepository.registerAllOrdered(items);
    }

    @Override
    public void registerWithKeys(Map<RepositoryObjectKey, FunctionRepository> objects) {
        this.innerRepository.registerAll(objects);
    }

    @Override
    public Function getFunction(String functionName) {
        Function function = this.functionCache.get(functionName);
        if (function == null) {
            function = this.searchForFunction(functionName);
            if (function == null) {
                throw new UnknownFunctionException(functionName);
            }
            this.functionCache.put(functionName, function);
        }
        return function;
    }

    private Function searchForFunction(String functionName) {
        FunctionRepository repository;
        Function function = null;
        Iterator<FunctionRepository> iterator = this.innerRepository.getItemsOrdered().values().iterator();
        while (iterator.hasNext() && (function = (repository = iterator.next()).loadFunction(functionName)) == null) {
        }
        return function;
    }

    @Override
    public FunctionCache getFunctionCache() {
        return this.functionCache;
    }
}

