/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.io.File;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import org.zaproxy.clientapi.core.Alert;
import org.zaproxy.clientapi.core.AlertsFile;
import org.zaproxy.clientapi.core.ClientApi;

public class ClientApiMain {
    private HashMap<String, Object> params = new HashMap();
    private String zapaddr = "localhost";
    private int zapport = 8090;
    private Task task;
    private ClientApi api;
    private boolean debug = false;

    public static void main(String[] args) {
        new ClientApiMain(args);
    }

    public ClientApiMain(String[] args) {
        this.initialize(args);
        try {
            this.executeTask();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showHelp();
        }
    }

    private void executeTask() throws Exception {
        try {
            switch (this.task) {
                case stop: {
                    this.api.core.shutdown();
                    break;
                }
                case checkAlerts: {
                    File alertsFile;
                    if (this.params.get("alertsFile") == null) {
                        System.out.println("No Alerts File Path Supplied\n");
                        this.showHelp();
                        System.exit(1);
                    }
                    if (!(alertsFile = (File)this.params.get("alertsFile")).exists()) {
                        System.out.println("File not Found: " + alertsFile.getAbsolutePath());
                        this.showHelp();
                        System.exit(1);
                    }
                    if (this.params.get("outputFile") == null) {
                        this.api.checkAlerts(AlertsFile.getAlertsFromFile(alertsFile, "ignoreAlert"), AlertsFile.getAlertsFromFile(alertsFile, "requireAlert"));
                        break;
                    }
                    File outFile = (File)this.params.get("outputFile");
                    try {
                        this.api.checkAlerts(AlertsFile.getAlertsFromFile(alertsFile, "ignoreAlert"), AlertsFile.getAlertsFromFile(alertsFile, "requireAlert"), outFile);
                    }
                    catch (AssertionError e) {
                        System.out.println(((Throwable)((Object)e)).getMessage());
                        System.exit(1);
                    }
                    break;
                }
                case showAlerts: {
                    List<Alert> alerts = this.api.getAlerts(null, -1, -1);
                    for (Alert alert : alerts) {
                        System.out.println(alert.toString());
                    }
                    break;
                }
                case saveSession: {
                    if (this.params.get("sessionName") == null) {
                        System.out.println("No session name supplied\n");
                        this.showHelp();
                        System.exit(1);
                    }
                    this.api.core.saveSession((String)this.params.get("sessionName"), "true");
                    break;
                }
                case newSession: {
                    if (this.params.get("sessionName") == null) {
                        this.api.core.newSession("", "true");
                        break;
                    }
                    this.api.core.newSession((String)this.params.get("sessionName"), "true");
                    break;
                }
                case activeScanUrl: {
                    if (this.params.get("url") == null) {
                        System.out.println("No url supplied\n");
                        this.showHelp();
                        System.exit(1);
                        break;
                    }
                    this.api.ascan.scan((String)this.params.get("url"), "true", "false", "", "", "");
                    break;
                }
                case activeScanSiteInScope: {
                    this.checkForUrlParam();
                    this.api.activeScanSiteInScope((String)this.params.get("url"));
                    break;
                }
                case addExcludeRegexToContext: {
                    this.checkForContextNameParam();
                    this.checkForRegexParam();
                    this.api.context.excludeFromContext((String)this.params.get("contextName"), (String)this.params.get("regex"));
                    break;
                }
                case addIncludeRegexToContext: {
                    this.checkForContextNameParam();
                    this.checkForRegexParam();
                    this.api.context.includeInContext((String)this.params.get("contextName"), (String)this.params.get("regex"));
                    break;
                }
                case addIncludeOneMatchingNodeToContext: {
                    this.checkForContextNameParam();
                    this.checkForRegexParam();
                    this.api.includeOneMatchingNodeInContext((String)this.params.get("contextName"), (String)this.params.get("regex"));
                }
            }
        }
        catch (ConnectException e) {
            System.out.println(e.getMessage() + String.format(": zapaddr=%s, zapport=%d\n", this.zapaddr, this.zapport));
            this.showHelp();
            System.exit(1);
        }
    }

    private void checkForRegexParam() {
        if (this.params.get("regex") == null) {
            System.out.println("No regex supplied\n");
            this.showHelp();
            System.exit(1);
        }
    }

    private void checkForContextNameParam() {
        if (this.params.get("contextName") == null) {
            System.out.println("No context name supplied\n");
            this.showHelp();
            System.exit(1);
        }
    }

    private void checkForUrlParam() {
        if (this.params.get("url") == null) {
            System.out.println("No url supplied\n");
            this.showHelp();
            System.exit(1);
        }
    }

    private void initialize(String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                try {
                    this.setTask(args[1]);
                }
                catch (IndexOutOfBoundsException e) {
                    this.showHelp();
                    System.exit(1);
                }
                this.showHelp();
                System.exit(0);
            }
            this.setTask(args[0]);
            for (String arg : args) {
                String[] pair = arg.split("=");
                if (pair.length != 2) continue;
                if (pair[0].equalsIgnoreCase("zapaddr")) {
                    this.zapaddr = pair[1];
                    continue;
                }
                if (pair[0].equalsIgnoreCase("zapport")) {
                    try {
                        this.zapport = Integer.parseInt(pair[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid value to zapport, must be in integer: " + pair[1]);
                        this.showHelp();
                        System.exit(1);
                    }
                    continue;
                }
                if (pair[0].equalsIgnoreCase("debug") && pair[1].equalsIgnoreCase("true")) {
                    this.debug = true;
                    continue;
                }
                if (pair[0].contains("File")) {
                    this.params.put(pair[0], new File(pair[1]));
                    continue;
                }
                this.params.put(pair[0], pair[1]);
            }
        } else {
            this.showHelp();
            System.exit(1);
        }
        this.api = new ClientApi(this.zapaddr, this.zapport, (String)this.params.get("apikey"), this.debug);
    }

    private void setTask(String arg) {
        try {
            this.task = Task.valueOf(arg);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Unknown Task: " + arg);
            this.showHelp();
            System.exit(1);
        }
    }

    private void showHelp() {
        String help = "";
        if (this.task == null) {
            help = "usage: java -jar zap-api.jar <subcommand> [args]\n\nType 'java -jar zap-api.jar help <subcommand>' for help on a specific subcommand.\n\nAvailable subcommands:\n\tstop\n\tcheckAlerts\n\tshowAlerts\n\tsaveSession\n\tnewSession\n";
        } else {
            switch (this.task) {
                case stop: {
                    help = "usage: stop [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar stop' \n\t\tStop zap listening on default settings (localhost:8090)\n\t2. Type 'java -jar zap-api.jar stop zapaddr=192.168.1.1 apikey=1234' \n\t\tStop zap listening on 192.168.1.1:8090\n\t3. Type 'java -jar zap-api.jar stop zapport=7080 apikey=1234' \n\t\tStop zap listening on localhost:7080\n\t4. Type 'java -jar zap-api.jar stop zapaddr=192.168.1.1 zapport=7080 apikey=1234' \n\t\tStop zap listening on 192.168.1.1:7080\n\n";
                    break;
                }
                case checkAlerts: {
                    help = "usage: checkAlerts alertsFile={PATH} [outputFile={PATH}] [zapaddr={ip}] [zapport={port}]\n\nExamples\n\t1. Type 'java -jar zap-api.jar checkAlerts alertsFile=\"C:\\Users\\me\\My Documents\\alerts.xml\"' \n\t\tCheck alerts ignoring alerts from alertsFile, looking for required alerts from alertsFile, using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar checkAlerts alertsFile=\"C:\\Users\\me\\My Documents\\alerts.xml\" outputFile=\"C:\\Users\\me\\My Documents\\report.xml\"' \n\t\tCheck alerts ignoring alerts from alertsFile, looking for required alerts from alertsFile. Outputting results to report.xml, using zap listening on localhost:8090\n\t3. Type 'java -jar zap-api.jar checkAlerts alertsFile=\"C:\\Users\\me\\My Documents\\alerts.xml\" outputFile=\"C:\\Users\\me\\My Documents\\report.xml\"' zapaddr=192.168.1.1 zapport=7080' \n\t\tCheck alerts ignoring alerts from alertsFile, looking for required alerts from alertsFile. Outputting results to report.xml, using zap listening on 192.168.1.1:7080\nNote: for paths containing spaces ensure path is enclosed in quotes\n\n";
                    break;
                }
                case showAlerts: {
                    help = "usage: showAlerts [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar showAlerts' \n\t\tShow alerts, using zap listening on default settings (localhost:8090)\n\t2. Type 'java -jar zap-api.jar showAlerts zapaddr=192.168.1.1' \n\t\tShow alerts, using zap listening on 192.168.1.1:8090\n\t3. Type 'java -jar zap-api.jar showAlerts zapport=7080' \n\t\tShow alerts, using zap listening on localhost:7080\n\t4. Type 'java -jar zap-api.jar showAlerts zapaddr=192.168.1.1 zapport=7080' \n\t\tShow alerts, using zap listening on 192.168.1.1:7080\n\n";
                    break;
                }
                case saveSession: {
                    help = "usage: saveSession sessionName={PATH} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar saveSession sessionName=\"Users/me/My Documents/mysession/mysessionfile\"' \n\t\tSave zap session using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar saveSession sessionName=\"Users/me/My Documents/mysession/mysessionfile\" zapaddr=192.168.1.1 zapport=7080' \n\t\tSave zap session using zap listening on 192.168.1.1:7080\nNote: for paths containing spaces ensure path is enclosed in quotes\n\n";
                    break;
                }
                case newSession: {
                    help = "usage: newSession [sessionName={PATH}] [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar newSession' \n\t\tStart new session using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar newSession zapaddr=192.168.1.1 zapport=7080' \n\t\tStart new session using zap listening on 192.168.1.1:7080\n\t3. Type 'java -jar zap-api.jar newSession sessionName=\"Users/me/My Documents/mysession/newsession\"' \n\t\tStart new session using zap listening on localhost:8090, creating session files at /Users/me/My Documents/mysession/newsession\n\t4. Type 'java -jar zap-api.jar newSession sessionName=\"Users/me/My Documents/mysession/mysessionfile\" zapaddr=192.168.1.1 zapport=7080' \n\t\tStart new session using zap listening on 192.168.1.1:7080, creating session files at /Users/me/My Documents/mysession/newsession\nNote: for paths containing spaces ensure path is enclosed in quotes";
                    break;
                }
                case activeScanUrl: {
                    help = "usage: activeScanUrl url={url} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar activeScanUrl url=http://myurl.com/' \n\t\tExecute and active scan on http://myurl.com/ using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar activeScanUrl url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tExecute and active scan on http://myurl.com/ using zap listening on 192.168.1.1:7080\n\t";
                    break;
                }
                case addExcludeRegexToContext: {
                    help = "usage: addExcludeRegexToContext contextName={contextName} regex={regex} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar addExcludeRegexToContext contextName=1 regex=\\Qhttp://example.com/area\\E.* \n\t\tUrls that match the regex will be excluded from scope using context '1' using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar addExcludeRegexToContext url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tUrls that match the regex will be excluded from scope using context '1' using zap listening on 192.168.1.1:7080\n\t";
                    break;
                }
                case addIncludeRegexToContext: {
                    help = "usage: addIncludeRegexToContext contextName={contextName} regex={regex} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar addIncludeRegexToContext contextName=1 regex=\\Qhttp://example.com/area\\E.* \n\t\tUrls that match the regex will be included in scope using context '1' using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar addIncludeRegexToContext url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tUrls that match the regex will be included in scope using context '1' using zap listening on 192.168.1.1:7080\n\t";
                    break;
                }
                case addIncludeOneMatchingNodeToContext: {
                    help = "usage: addIncludeOneMatchingNodeToContext contextName={contextName} regex={regex} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar addIncludeOneMatchingNodeToContext contextName=1 regex=\\Qhttp://example.com/area\\E.* \n\t\tThe first url from the current session that matches the regex will be included in scope using context '1'. Any other matching url will be excluded from scope using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar addIncludeOneMatchingNodeToContext url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tThe first url from the current session that matches the regex will be included in scope using context '1'. Any other matching url will be excluded from scope using context '1' using zap listening on 192.168.1.1:7080\n\t";
                }
            }
        }
        System.out.println(help);
    }

    private static enum Task {
        stop,
        showAlerts,
        checkAlerts,
        saveSession,
        newSession,
        activeScanUrl,
        activeScanSiteInScope,
        addExcludeRegexToContext,
        addIncludeRegexToContext,
        addIncludeOneMatchingNodeToContext;

    }
}

