/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.security.MissingRootCertificateException;
import org.zaproxy.addon.network.internal.cert.GenerationException;

@ChannelHandler.Sharable
public class ServerExceptionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LogManager.getLogger(ServerExceptionHandler.class);
    private static final ServerExceptionHandler INSTANCE = new ServerExceptionHandler();

    public static ServerExceptionHandler getInstance() {
        return INSTANCE;
    }

    public boolean isSharable() {
        return true;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ServerExceptionHandler.logCause(cause);
        ctx.close();
    }

    private static void logCause(Throwable cause) {
        if (cause instanceof ReadTimeoutException) {
            LOGGER.debug("Timed out while reading message.");
            return;
        }
        if (cause instanceof HttpMalformedHeaderException) {
            LOGGER.warn("Received malformed header: {}", (Object)cause.getMessage());
            return;
        }
        if (cause instanceof IOException) {
            LOGGER.debug((Object)cause, cause);
            return;
        }
        if (!(cause instanceof DecoderException)) {
            LOGGER.error((Object)cause, cause);
            return;
        }
        Throwable nestedCause = cause.getCause();
        if (nestedCause == null) {
            LOGGER.error((Object)cause, cause);
            return;
        }
        if (nestedCause instanceof SSLHandshakeException) {
            LOGGER.warn("Failed while establishing secure connection, cause: {}", (Object)cause.getCause().getMessage());
            return;
        }
        if (nestedCause instanceof GenerationException || nestedCause instanceof MissingRootCertificateException) {
            LOGGER.warn("Failed while creating certificate, cause: {}", (Object)nestedCause.getMessage());
            return;
        }
        LOGGER.error((Object)nestedCause, nestedCause);
    }
}

