/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.addon.network.internal.ChannelAttributes;
import org.zaproxy.addon.network.internal.server.ServerConfig;

@ChannelHandler.Sharable
public class RecursiveRequestHandler
extends SimpleChannelInboundHandler<HttpMessage> {
    private static final Logger LOGGER = LogManager.getLogger(RecursiveRequestHandler.class);
    private static final RecursiveRequestHandler INSTANCE = new RecursiveRequestHandler();
    private static AwsCandidateHarvester awsCandidateHarvester;

    public static RecursiveRequestHandler getInstance() {
        return INSTANCE;
    }

    public boolean isSharable() {
        return true;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        if (msg.getUserObject() instanceof Exception) {
            throw (Exception)msg.getUserObject();
        }
        Channel channel = ctx.channel();
        boolean recursive = false;
        if (!"CONNECT".equals(msg.getRequestHeader().getMethod())) {
            ServerConfig serverConfig = (ServerConfig)channel.attr(ChannelAttributes.SERVER_CONFIG).get();
            InetSocketAddress localInetAddress = (InetSocketAddress)channel.attr(ChannelAttributes.LOCAL_ADDRESS).get();
            recursive = RecursiveRequestHandler.isRecursive(serverConfig, localInetAddress, msg.getRequestHeader());
        }
        channel.attr(ChannelAttributes.RECURSIVE_MESSAGE).set((Object)recursive);
        ctx.fireChannelRead((Object)msg);
    }

    private static boolean isRecursive(ServerConfig serverConfig, InetSocketAddress localInetAddress, HttpRequestHeader header) {
        try {
            String targetDomain = header.getHostName();
            if (serverConfig.getAliases().contains(targetDomain)) {
                return true;
            }
            if (header.getHostPort() == localInetAddress.getPort() && RecursiveRequestHandler.isServerAddress(InetAddress.getByName(targetDomain), serverConfig, localInetAddress.getAddress())) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static boolean isServerAddress(InetAddress address, ServerConfig serverConfig, InetAddress serverAddress) {
        return serverConfig.isAnyLocalAddress() ? RecursiveRequestHandler.isLocalAddress(address) || RecursiveRequestHandler.isNetworkInterfaceAddress(address) || RecursiveRequestHandler.isOwnPublicAddress(serverConfig, address) : address.equals(serverAddress);
    }

    private static boolean isLocalAddress(InetAddress address) {
        return address.isLoopbackAddress() || address.isSiteLocalAddress() || address.isAnyLocalAddress();
    }

    private static boolean isNetworkInterfaceAddress(InetAddress address) {
        try {
            if (NetworkInterface.getByInetAddress(address) != null) {
                return true;
            }
        }
        catch (SocketException e) {
            LOGGER.warn("Failed to check if an address is from a network interface:", (Throwable)e);
        }
        return false;
    }

    private static boolean isOwnPublicAddress(ServerConfig serverConfig, InetAddress address) {
        if (!serverConfig.isBehindNat()) {
            return false;
        }
        TransportAddress publicAddress = RecursiveRequestHandler.getAwsCandidateHarvester().getMask();
        if (publicAddress == null) {
            return false;
        }
        return Arrays.equals(address.getAddress(), publicAddress.getAddress().getAddress());
    }

    private static AwsCandidateHarvester getAwsCandidateHarvester() {
        if (awsCandidateHarvester == null) {
            RecursiveRequestHandler.createAwsCandidateHarvester();
        }
        return awsCandidateHarvester;
    }

    private static synchronized void createAwsCandidateHarvester() {
        if (awsCandidateHarvester == null) {
            awsCandidateHarvester = new AwsCandidateHarvester();
        }
    }
}

