/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import org.zaproxy.addon.network.internal.ChannelAttributes;

public class LegacySocketAdapter
extends SimpleChannelInboundHandler<ByteBuf> {
    static final String HANDLER_NAME = "legacy.socket";
    private final LinkedBlockingQueue<Integer> pendingReads;
    private final ByteBuf buf;
    private final Channel inboundChannel;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final Socket socket;

    public LegacySocketAdapter(Channel channel) {
        this.inboundChannel = Objects.requireNonNull(channel);
        this.pendingReads = new LinkedBlockingQueue();
        this.buf = Unpooled.buffer();
        this.inputStream = new InputStreamImpl();
        this.outputStream = new OutputStreamImpl();
        this.socket = new SocketImpl();
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.remove("timeout");
        if (((Boolean)channel.attr(ChannelAttributes.TLS_UPGRADED).get()).booleanValue()) {
            pipeline.addAfter("tls", HANDLER_NAME, (ChannelHandler)this);
        } else {
            pipeline.addFirst(HANDLER_NAME, (ChannelHandler)this);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        this.buf.writeBytes(msg);
        this.pendingReads.offer(1);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.pendingReads.offer(1);
    }

    private class OutputStreamImpl
    extends OutputStream {
        private OutputStreamImpl() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Operation not supported");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            LegacySocketAdapter.this.inboundChannel.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])b, (int)off, (int)len));
        }

        @Override
        public void close() throws IOException {
            LegacySocketAdapter.this.inboundChannel.close();
        }
    }

    private class InputStreamImpl
    extends InputStream {
        private InputStreamImpl() {
        }

        @Override
        public int read() throws IOException {
            throw new IOException("Operation not supported");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                LegacySocketAdapter.this.pendingReads.take();
                if (!LegacySocketAdapter.this.inboundChannel.isActive()) {
                    LegacySocketAdapter.this.buf.release();
                    return -1;
                }
                int read = Math.min(len, LegacySocketAdapter.this.buf.readableBytes());
                LegacySocketAdapter.this.buf.readBytes(b, off, read);
                while (!LegacySocketAdapter.this.buf.isReadable() && LegacySocketAdapter.this.pendingReads.poll() != null) {
                }
                return read;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return -1;
            }
        }

        @Override
        public void close() throws IOException {
            LegacySocketAdapter.this.inboundChannel.close().addListener(f -> LegacySocketAdapter.this.pendingReads.offer(1));
        }
    }

    private class SocketImpl
    extends Socket {
        private SocketImpl() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return LegacySocketAdapter.this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return LegacySocketAdapter.this.outputStream;
        }

        @Override
        public boolean isClosed() {
            return !LegacySocketAdapter.this.inboundChannel.isActive();
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public void setKeepAlive(boolean on) throws SocketException {
            LegacySocketAdapter.this.inboundChannel.config().setOption(ChannelOption.SO_KEEPALIVE, (Object)on);
        }

        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            LegacySocketAdapter.this.inboundChannel.config().setOption(ChannelOption.TCP_NODELAY, (Object)on);
        }
    }
}

