/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.cert;

import io.netty.util.NetUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.security.CertData;
import org.parosproxy.paros.security.SslCertificateService;
import org.zaproxy.addon.network.internal.cert.GenerationException;

public class SniX509KeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOGGER = LogManager.getLogger(SniX509KeyManager.class);
    private final SslCertificateService sslCertificateService;
    private final String fallbackHostname;
    private InetAddress listeningAddress;
    private X509KeyManager x509KeyManager;

    public SniX509KeyManager(SslCertificateService sslCertificateService, InetAddress listeningAddress, String fallbackHostname) {
        this.sslCertificateService = Objects.requireNonNull(sslCertificateService);
        this.listeningAddress = Objects.requireNonNull(listeningAddress);
        this.fallbackHostname = fallbackHostname;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.x509KeyManager == null) {
            this.createX509KeyManager(engine);
        }
        return this.x509KeyManager.chooseServerAlias(keyType, issuers, null);
    }

    private void createX509KeyManager(SSLEngine engine) {
        String hostname;
        SSLSession session = engine.getHandshakeSession();
        if (session == null) {
            LOGGER.warn("No handshake session to extract the domain.");
        }
        if ((hostname = SniX509KeyManager.extractHostname(session)) == null) {
            LOGGER.debug("No domain extracted from handshake session, fallback to: {}", (Object)this.fallbackHostname);
            hostname = this.fallbackHostname;
        } else {
            LOGGER.debug("Domain extracted from handshake session: {}", (Object)hostname);
        }
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            SniX509KeyManager.initKeyManagerFactoryWithCertForHostname(this.sslCertificateService, keyManagerFactory, hostname, this.listeningAddress);
        }
        catch (IOException | GeneralSecurityException e) {
            SniX509KeyManager.logAndThrow("Failed to generate the certificate for '" + hostname + "' caused by: " + e.getMessage(), e);
        }
        this.x509KeyManager = SniX509KeyManager.getX509KeyManager(keyManagerFactory.getKeyManagers());
        if (this.x509KeyManager == null) {
            SniX509KeyManager.logAndThrow("No X509KeyManager found in: " + Arrays.toString(keyManagerFactory.getKeyManagers()));
        }
    }

    private static void logAndThrow(String message) {
        SniX509KeyManager.logAndThrow(message, null);
    }

    private static void logAndThrow(String message, Throwable cause) {
        LOGGER.warn(message, cause);
        throw new GenerationException(message, cause);
    }

    private static X509KeyManager getX509KeyManager(KeyManager[] keyManagers) {
        for (int i = 0; i < keyManagers.length; ++i) {
            KeyManager keyManager = keyManagers[i];
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        return null;
    }

    private static String extractHostname(SSLSession sslSession) {
        if (sslSession instanceof ExtendedSSLSession) {
            for (SNIServerName serverName : ((ExtendedSSLSession)sslSession).getRequestedServerNames()) {
                if (serverName.getType() != 0) continue;
                return ((SNIHostName)serverName).getAsciiName();
            }
        }
        return null;
    }

    private static void initKeyManagerFactoryWithCertForHostname(SslCertificateService sslCertificateService, KeyManagerFactory keyManagerFactory, String hostname, InetAddress listeningAddress) throws GeneralSecurityException, IOException {
        CertData certData;
        boolean hostnameIsIpAddress = SniX509KeyManager.isIpAddress(hostname);
        CertData certData2 = certData = hostnameIsIpAddress ? new CertData() : new CertData(hostname);
        if (hostname == null) {
            certData.addSubjectAlternativeName(new CertData.Name(7, listeningAddress.getHostAddress()));
        }
        if (hostnameIsIpAddress) {
            certData.addSubjectAlternativeName(new CertData.Name(7, hostname));
        }
        KeyStore ks = sslCertificateService.createCertForHost(certData);
        keyManagerFactory.init(ks, SslCertificateService.PASSPHRASE);
    }

    private static boolean isIpAddress(String value) {
        return value != null && !value.isEmpty() && (NetUtil.isValidIpV4Address((String)value) || NetUtil.isValidIpV6Address((String)value));
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.x509KeyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.x509KeyManager.getPrivateKey(alias);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return null;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return null;
    }
}

