/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TlsUtils {
    public static final String SSL_V2_HELLO = "SSLv2Hello";
    public static final String SSL_V3 = "SSLv3";
    public static final String TLS_V1 = "TLSv1";
    public static final String TLS_V1_1 = "TLSv1.1";
    public static final String TLS_V1_2 = "TLSv1.2";
    public static final String TLS_V1_3 = "TLSv1.3";
    private static final Logger LOGGER;
    private static final String PROTOCOL = "TLS";
    private static final List<String> FALLBACK_PROTOCOLS;
    private static final List<String> SUPPORTED_PROTOCOLS;

    private TlsUtils() {
    }

    public static List<String> getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public static List<String> filterUnsupportedProtocols(List<String> protocols) {
        if (protocols == null || protocols.isEmpty()) {
            throw new IllegalArgumentException("Protocol(s) required but no protocol set.");
        }
        List enabledSupportedProtocols = protocols.stream().filter(SUPPORTED_PROTOCOLS::contains).collect(Collectors.toList());
        if (enabledSupportedProtocols.isEmpty()) {
            throw new IllegalArgumentException("No supported protocol(s) set.");
        }
        if (enabledSupportedProtocols.size() == 1 && enabledSupportedProtocols.contains(SSL_V2_HELLO)) {
            throw new IllegalArgumentException("Only SSLv2Hello set, must have at least one SSL/TLS version enabled.");
        }
        return Collections.unmodifiableList(enabledSupportedProtocols);
    }

    static {
        List<String> tempSupportedProtocols;
        LOGGER = LogManager.getLogger(TlsUtils.class);
        FALLBACK_PROTOCOLS = Arrays.asList(TLS_V1_2);
        LOGGER.debug("Reading supported SSL/TLS protocols...");
        try {
            SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
            sslContext.init(null, null, null);
            tempSupportedProtocols = Arrays.asList(sslContext.getDefaultSSLParameters().getProtocols());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOGGER.error("Failed to read the SSL/TLS supported protocols. Using fallback protocol versions: {}", FALLBACK_PROTOCOLS, (Object)e);
            tempSupportedProtocols = FALLBACK_PROTOCOLS;
        }
        Collections.sort(tempSupportedProtocols);
        SUPPORTED_PROTOCOLS = Collections.unmodifiableList(tempSupportedProtocols);
        LOGGER.info("Using supported SSL/TLS protocols: {}", SUPPORTED_PROTOCOLS);
    }
}

