/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.swagger.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import io.swagger.util.Yaml;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.zalando.stups.swagger.codegen.CodegeneratorLogger;
import org.zalando.stups.swagger.codegen.SystemOutCodegeneratorLogger;

public class YamlToJson {
    private String outputDirectoryPath;
    private String yamlInputPath;
    private CodegeneratorLogger logger = new SystemOutCodegeneratorLogger();

    private YamlToJson(String yamlInputPath, String outputDirectoryPath, CodegeneratorLogger codegeneratorLogger) {
        this.yamlInputPath = yamlInputPath;
        this.outputDirectoryPath = outputDirectoryPath;
        this.logger = codegeneratorLogger;
    }

    public void convert() {
        this.logger.info("Generate .json file from .yaml");
        File outputDirectory = new File(this.outputDirectoryPath);
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
            this.logger.info("OutputDirectory created");
        }
        File jsonFile = new File(outputDirectory, this.getYamlFilename() + ".json");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(jsonFile);
            fileWriter.write(this.getYamlFileContentAsJson());
            fileWriter.flush();
            this.logger.info("File written to " + jsonFile.getAbsolutePath());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    protected String getYamlFileContentAsJson() throws IOException {
        String data = "";
        data = this.yamlInputPath.startsWith("http") || this.yamlInputPath.startsWith("https") ? new String(Resources.toByteArray((URL)new URL(this.yamlInputPath))) : new String(Files.readAllBytes(Paths.get(new File(this.yamlInputPath).toURI())));
        ObjectMapper yamlMapper = Yaml.mapper();
        JsonNode rootNode = yamlMapper.readTree(data);
        JsonNode swaggerNode = rootNode.get("swagger");
        return rootNode.toString();
    }

    protected String getYamlFilename() {
        if (this.yamlInputPath.startsWith("http") || this.yamlInputPath.startsWith("https")) {
            int lastSlashIndex = this.yamlInputPath.lastIndexOf("/");
            String filename = this.yamlInputPath.substring(lastSlashIndex + 1);
            return this.filenameSubstring(filename);
        }
        File file = new File(this.yamlInputPath);
        if (!file.exists()) {
            throw new RuntimeException("Api-File not found: " + this.yamlInputPath);
        }
        String filename = file.getName();
        return this.filenameSubstring(filename);
    }

    protected String filenameSubstring(String filename) {
        return filename.substring(0, filename.indexOf("."));
    }

    public static YamlToJsonBuilder builder() {
        return new YamlToJsonBuilder();
    }

    public static class YamlToJsonBuilder {
        private String yamlInputPath;
        private String outputDirectoryPath;
        private CodegeneratorLogger codegeneratorLogger = new SystemOutCodegeneratorLogger();

        public YamlToJsonBuilder withYamlInputPath(String yamlInputPath) {
            this.yamlInputPath = yamlInputPath;
            return this;
        }

        public YamlToJsonBuilder withOutputDirectoryPath(String outputDirectoryPath) {
            this.outputDirectoryPath = outputDirectoryPath;
            return this;
        }

        public YamlToJsonBuilder withCodegeneratorLogger(CodegeneratorLogger codegeneratorLogger) {
            this.codegeneratorLogger = codegeneratorLogger;
            return this;
        }

        public YamlToJson build() {
            return new YamlToJson(this.yamlInputPath, this.outputDirectoryPath, this.codegeneratorLogger);
        }
    }
}

