/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.webflux.advice.validation;

import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apiguardian.api.API;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.webflux.advice.validation.BaseValidationAdviceTrait;
import org.zalando.problem.violations.Violation;
import reactor.core.publisher.Mono;

@API(status=API.Status.STABLE)
public interface ConstraintViolationAdviceTrait
extends BaseValidationAdviceTrait {
    default public Violation createViolation(ConstraintViolation violation) {
        return new Violation(this.formatFieldName(violation.getPropertyPath().toString()), violation.getMessage());
    }

    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public Mono<ResponseEntity<Problem>> handleConstraintViolation(ConstraintViolationException exception, ServerWebExchange request) {
        List<Violation> violations = exception.getConstraintViolations().stream().map(this::createViolation).collect(Collectors.toList());
        return this.newConstraintViolationProblem((Throwable)exception, violations, request);
    }
}

