/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.http;

import java.util.Objects;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.spring.web.advice.AdviceTrait;

@API(status=API.Status.STABLE)
public interface MethodNotAllowedAdviceTrait
extends AdviceTrait {
    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public ResponseEntity<Problem> handleRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException exception, NativeWebRequest request) {
        String[] methods = exception.getSupportedMethods();
        if (methods == null || methods.length == 0) {
            return this.create((StatusType)Status.METHOD_NOT_ALLOWED, (Throwable)exception, request);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Objects.requireNonNull(exception.getSupportedHttpMethods()));
        return this.create((StatusType)Status.METHOD_NOT_ALLOWED, (Throwable)exception, request, headers);
    }
}

