/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.zalando.problem.spring.web.advice.validation.BaseValidationAdviceTrait;
import org.zalando.problem.spring.web.advice.validation.Violation;

@API(status=API.Status.INTERNAL)
public interface BaseBindingResultAdviceTrait
extends BaseValidationAdviceTrait {
    default public Violation createViolation(FieldError error) {
        String fieldName = this.formatFieldName(error.getField());
        return new Violation(fieldName, error.getDefaultMessage());
    }

    default public Violation createViolation(ObjectError error) {
        String fieldName = this.formatFieldName(error.getObjectName());
        return new Violation(fieldName, error.getDefaultMessage());
    }

    default public List<Violation> createViolations(BindingResult result) {
        Stream<Violation> fieldErrors = result.getFieldErrors().stream().map(this::createViolation);
        Stream<Violation> globalErrors = result.getGlobalErrors().stream().map(this::createViolation);
        return Stream.concat(fieldErrors, globalErrors).collect(Collectors.toList());
    }
}

