/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration.junit5;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.xwiki.rendering.test.integration.TestDataGenerator;
import org.xwiki.rendering.test.integration.junit5.RenderingTestExecutor;

public interface RenderingTests {
    public static final String DEFAULT_PATTERN = ".*\\.test";

    @TestFactory
    default public Stream<DynamicTest> renderingTests() {
        Scope scopeAnnotation = this.getClass().getAnnotation(Scope.class);
        String packagePrefix = "";
        String pattern = DEFAULT_PATTERN;
        if (scopeAnnotation != null) {
            packagePrefix = scopeAnnotation.value();
            pattern = scopeAnnotation.pattern();
        }
        TestDataGenerator generator = new TestDataGenerator();
        List parametersList = (List)generator.generateData(packagePrefix, pattern);
        Function<Object[], String> displayNameGenerator = input -> (String)input[0];
        RenderingTestExecutor executor = new RenderingTestExecutor();
        ThrowingConsumer testExecutor = input -> executor.execute((Object[])input, this);
        return DynamicTest.stream(parametersList.iterator(), displayNameGenerator, (ThrowingConsumer)testExecutor);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Scope {
        public String value() default "";

        public String pattern() default ".*\\.test";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Initialized {
    }
}

