/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration.junit5;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.opentest4j.IncompleteExecutionException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.test.integration.junit5.RenderingTest;
import org.xwiki.rendering.test.integration.junit5.RenderingTests;
import org.xwiki.test.annotation.AllComponents;
import org.xwiki.test.annotation.ComponentList;
import org.xwiki.test.jmock.XWikiComponentInitializer;
import org.xwiki.test.mockito.MockitoComponentManager;

public class RenderingTestExecutor {
    private final XWikiComponentInitializer componentInitializer = new XWikiComponentInitializer();
    private final MockitoComponentManager mockitoComponentManager = new MockitoComponentManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object[] objects, Object testInstance) throws Exception {
        this.initializeComponentManager(testInstance);
        try {
            for (Method klassMethod : testInstance.getClass().getMethods()) {
                RenderingTests.Initialized componentManagerAnnotation = klassMethod.getAnnotation(RenderingTests.Initialized.class);
                if (componentManagerAnnotation == null) continue;
                klassMethod.invoke(testInstance, this.getComponentManager(testInstance));
            }
        }
        catch (Exception e) {
            throw new IncompleteExecutionException("Failed to call Component Manager initialization method", (Throwable)e);
        }
        try {
            Object[] newObjects = this.computeParams(objects, testInstance);
            RenderingTest renderingTest = new RenderingTest((String)newObjects[0], (String)newObjects[1], (String)newObjects[2], (String)newObjects[3], (Boolean)newObjects[4], (List)newObjects[5], (Map)newObjects[6], (ComponentManager)newObjects[7]);
            renderingTest.execute();
        }
        finally {
            this.shutdownComponentManager(testInstance);
        }
    }

    private Object[] computeParams(Object[] originalObjects, Object testInstance) throws Exception {
        Object[] newObjects = new Object[originalObjects.length];
        System.arraycopy(originalObjects, 1, newObjects, 0, originalObjects.length - 1);
        newObjects[originalObjects.length - 1] = this.getComponentManager(testInstance);
        return newObjects;
    }

    private void initializeComponentManager(Object testInstance) {
        try {
            if (this.isLegacyMode(testInstance)) {
                this.componentInitializer.initializeConfigurationSource();
                this.componentInitializer.initializeExecution();
            } else {
                this.mockitoComponentManager.initializeTest(testInstance, new Object[0]);
                this.mockitoComponentManager.registerMemoryConfigurationSource();
            }
        }
        catch (Exception e) {
            throw new IncompleteExecutionException("Failed to initialize Component Manager", (Throwable)e);
        }
    }

    private void shutdownComponentManager(Object testInstance) {
        try {
            if (this.isLegacyMode(testInstance)) {
                this.componentInitializer.shutdown();
            } else {
                this.mockitoComponentManager.shutdownTest();
            }
        }
        catch (Exception e) {
            throw new IncompleteExecutionException("Failed to shutdown Component Manager", (Throwable)e);
        }
    }

    private ComponentManager getComponentManager(Object testInstance) throws Exception {
        if (this.isLegacyMode(testInstance)) {
            return this.componentInitializer.getComponentManager();
        }
        return this.mockitoComponentManager;
    }

    private boolean isLegacyMode(Object testInstance) {
        boolean isLegacyMode = true;
        for (Method klassMethod : testInstance.getClass().getMethods()) {
            RenderingTests.Initialized componentManagerAnnotation = klassMethod.getAnnotation(RenderingTests.Initialized.class);
            if (componentManagerAnnotation == null) continue;
            if (!MockitoComponentManager.class.isAssignableFrom(klassMethod.getParameterTypes()[0])) break;
            isLegacyMode = false;
            break;
        }
        if (isLegacyMode && (testInstance.getClass().getAnnotation(AllComponents.class) != null || testInstance.getClass().getAnnotation(ComponentList.class) != null)) {
            isLegacyMode = false;
        }
        return isLegacyMode;
    }
}

