/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test;

import java.util.Map;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.wiki.WikiModel;

public class MockWikiModel
implements WikiModel {
    private static final String QM = "?";

    public static ComponentDescriptor<WikiModel> getComponentDescriptor() {
        DefaultComponentDescriptor componentDescriptor = new DefaultComponentDescriptor();
        componentDescriptor.setRoleType(WikiModel.class);
        componentDescriptor.setImplementation(MockWikiModel.class);
        return componentDescriptor;
    }

    public String getLinkURL(ResourceReference linkReference) {
        String queryString = linkReference.getParameter("queryString");
        return "attachmenturl" + (queryString != null ? QM + queryString : "");
    }

    public String getImageURL(ResourceReference imageReference, Map<String, String> parameters) {
        String queryString = imageReference.getParameter("queryString");
        return "imageurl" + (queryString != null ? QM + queryString : "");
    }

    public String getDocumentEditURL(ResourceReference documentReference) {
        return "editurl";
    }

    public String getDocumentViewURL(ResourceReference documentReference) {
        String queryString = documentReference.getParameter("queryString");
        String anchor = documentReference.getParameter("anchor");
        return "viewurl" + (queryString != null ? QM + queryString : "") + (anchor != null ? "#" + anchor : "");
    }

    public boolean isDocumentAvailable(ResourceReference documentReference) {
        ResourceType resourceType = documentReference.getType();
        String resourceValue = documentReference.getReference();
        if (ResourceType.DOCUMENT.equals((Object)resourceType)) {
            return "Space.ExistingPage".equals(resourceValue);
        }
        if (ResourceType.SPACE.equals((Object)resourceType)) {
            return "ExistingSpace".equals(resourceValue);
        }
        if (ResourceType.PAGE.equals((Object)resourceType)) {
            return "ExistingPage".equals(resourceValue);
        }
        return false;
    }
}

