/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.image;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.renderer.xhtml.image.AbstractXHTMLImageTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@Named(value="attach")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class AttachmentXHTMLImageTypeRenderer
extends AbstractXHTMLImageTypeRenderer
implements Initializable {
    @Inject
    private Logger logger;
    private WikiModel wikiModel;

    public void initialize() throws InitializationException {
        if (this.componentManager.hasComponent(WikiModel.class)) {
            try {
                this.wikiModel = (WikiModel)this.componentManager.getInstance(WikiModel.class);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to initialize the default WikiModel implementation", (Throwable)e);
            }
        }
    }

    @Override
    protected String getImageSrcAttributeValue(ResourceReference reference, Map<String, String> parameters) {
        String imageSrcAttributeValue = this.wikiModel != null ? this.wikiModel.getImageURL(reference, parameters) : String.format("%s:%s", reference.getType().getScheme(), reference.getReference());
        return imageSrcAttributeValue;
    }
}

