/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml.internal.parser;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptor;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptorManager;
import org.xwiki.rendering.listener.descriptor.ListenerElement;
import org.xwiki.rendering.xdomxml.internal.parser.AbstractBlockParser;
import org.xwiki.rendering.xdomxml.internal.parser.parameters.CustomParametersParser;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultBlockParser
extends AbstractBlockParser {
    @Inject
    private ListenerDescriptorManager descriptorManager;
    private Set<String> parameterNames;
    private Map<String, String> parameters;
    private StringBuffer value;
    private ListenerDescriptor descriptor;
    private Map<String, String> customParameters = Collections.emptyMap();

    public DefaultBlockParser() {
    }

    protected DefaultBlockParser(Set<String> parameterNames) {
        if (parameterNames != null) {
            this.parameterNames = parameterNames;
            this.parameters = new HashMap<String, String>();
        }
    }

    @Override
    public void setListener(Listener listener) {
        super.setListener(listener);
        this.descriptor = this.descriptorManager.getListenerDescriptor(listener.getClass());
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public int getParameterAsInt(String name, int defaultValue) {
        String value = this.getParameters().get(name);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        String value = this.getParameters().get(name);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    public char getParameterAsChar(String name, char defaultValue) {
        String value = this.getParameters().get(name);
        return value != null && value.length() > 0 ? value.charAt(0) : defaultValue;
    }

    public String getParameterAsString(String name, String defaultValue) {
        String value = this.getParameters().get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    protected void startElementInternal(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.getLevel() > 0) {
            if (this.parameterNames != null && this.parameterNames.contains(qName)) {
                this.value = new StringBuffer();
            } else if (qName.equals("parameters")) {
                this.setCurrentHandler(new CustomParametersParser());
            }
        }
    }

    @Override
    public void charactersInternal(char[] ch, int start, int length) throws SAXException {
        if (this.value != null) {
            this.value.append(ch, start, length);
        }
    }

    @Override
    protected void endElementInternal(String uri, String localName, String qName) throws SAXException {
        if (this.getLevel() > 0) {
            if (this.value != null) {
                this.parameters.put(qName, this.value.toString());
            } else if (qName.equals("parameters")) {
                CustomParametersParser parametersParser = (CustomParametersParser)this.getCurrentHandler();
                this.customParameters = parametersParser.getValue();
            }
        }
    }

    private void sendEvent(Method method) throws SAXException {
        try {
            if (method.getParameterTypes().length == 0) {
                method.invoke((Object)this.getListener(), new Object[0]);
            } else {
                method.invoke((Object)this.getListener(), this.customParameters);
            }
        }
        catch (Exception e) {
            throw new SAXException("Failed to send listener event [" + method + "]", e);
        }
    }

    @Override
    protected void beginBlock() throws SAXException {
        if (this.getListener() != null) {
            String name = this.getBlockName().toUpperCase();
            ListenerElement element = (ListenerElement)this.descriptor.getElements().get(name.toLowerCase());
            if (element.getBeginMethod() != null) {
                this.sendEvent(element.getBeginMethod());
            }
        }
    }

    @Override
    protected void endBlock() throws SAXException {
        if (this.getListener() != null) {
            String name = this.getBlockName().toUpperCase();
            ListenerElement element = (ListenerElement)this.descriptor.getElements().get(name.toLowerCase());
            if (element.getOnMethod() != null) {
                this.sendEvent(element.getOnMethod());
            } else {
                this.sendEvent(element.getEndMethod());
            }
        }
    }
}

