/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml.internal.current.parameter;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class XDOMXMLTreeMarshaller
extends TreeMarshaller {
    public XDOMXMLTreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        super(writer, converterLookup, mapper);
    }

    public void start(Object item, DataHolder dataHolder) {
        Type type = (Type)dataHolder.get((Object)"type");
        if (item != null) {
            Converter converter = this.getConverter(type);
            if (converter == null) {
                this.convertAnother(item);
            } else {
                this.convert(item, converter);
            }
        }
    }

    private Converter getConverter(Type type) {
        if (type != null) {
            Class clazz = null;
            if (type instanceof ParameterizedType) {
                clazz = (Class)((ParameterizedType)type).getRawType();
            } else if (type instanceof Class) {
                clazz = (Class)type;
            } else {
                throw new ConversionException("Can't find any converter for the type [" + type + "]");
            }
            Converter converter = this.converterLookup.lookupConverterForType(clazz);
            if (converter.getClass() != ReflectionConverter.class) {
                return converter;
            }
        }
        return null;
    }
}

