/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.html5;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.html5.HTML5SyntaxProvider;
import org.xwiki.rendering.internal.parser.xhtml5.XHTML5Parser;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Named(value="html/5.0")
public class HTML5Parser
extends XHTML5Parser {
    @Inject
    private HTMLCleaner htmlCleaner;

    public XDOM parse(Reader source) throws ParseException {
        return super.parse((Reader)new StringReader(HTMLUtils.toString((Document)this.htmlCleaner.clean(source, this.getHTMLCleanerConfiguration()))));
    }

    public XDOM parse(Reader source, IdGenerator idGenerator) throws ParseException {
        return super.parse((Reader)new StringReader(HTMLUtils.toString((Document)this.htmlCleaner.clean(source, this.getHTMLCleanerConfiguration()))), idGenerator);
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        super.parse((Reader)new StringReader(HTMLUtils.toString((Document)this.htmlCleaner.clean(source, this.getHTMLCleanerConfiguration()))), listener);
    }

    public void parse(Reader source, Listener listener, IdGenerator idGenerator) throws ParseException {
        super.parse((Reader)new StringReader(HTMLUtils.toString((Document)this.htmlCleaner.clean(source, this.getHTMLCleanerConfiguration()))), listener, idGenerator);
    }

    public Syntax getSyntax() {
        return HTML5SyntaxProvider.HTML_5_0;
    }

    private HTMLCleanerConfiguration getHTMLCleanerConfiguration() {
        HTMLCleanerConfiguration configuration = this.htmlCleaner.getDefaultConfiguration();
        HashMap<String, String> parameters = new HashMap<String, String>(configuration.getParameters());
        parameters.put("htmlVersion", "5");
        configuration.setParameters(parameters);
        return configuration;
    }
}

