/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.syntax;

import java.util.HashMap;
import java.util.Map;

public class SyntaxType {
    private static final Map<String, SyntaxType> KNOWN_SYNTAX_TYPES = new HashMap<String, SyntaxType>();
    public static final SyntaxType XWIKI = SyntaxType.register("xwiki", "XWiki");
    public static final SyntaxType CONFLUENCE = SyntaxType.register("confluence", "Confluence");
    public static final SyntaxType MEDIAWIKI = SyntaxType.register("mediawiki", "MediaWiki");
    public static final SyntaxType CREOLE = SyntaxType.register("creole", "Creole");
    public static final SyntaxType JSPWIKI = SyntaxType.register("jspwiki", "JSPWiki");
    public static final SyntaxType TWIKI = SyntaxType.register("twiki", "TWiki");
    public static final SyntaxType XHTML = SyntaxType.register("xhtml", "XHTML");
    public static final SyntaxType ANNOTATED_XHTML = SyntaxType.register("annotatedxhtml", "Annotated XHTML");
    public static final SyntaxType HTML = SyntaxType.register("html", "HTML");
    public static final SyntaxType PLAIN = SyntaxType.register("plain", "Plain");
    public static final SyntaxType EVENT = SyntaxType.register("event", "Event");
    public static final SyntaxType TEX = SyntaxType.register("tex", "TeX");
    public static final SyntaxType DOCBOOK = SyntaxType.register("docbook", "DocBook");
    public static final SyntaxType XDOMXML = SyntaxType.register("xdom+xml", "XML based XDOM");
    public static final SyntaxType MARKDOWN = SyntaxType.register("markdown", "Markdown");
    public static final SyntaxType APT = SyntaxType.register("apt", "APT");
    private String name;
    private String id;

    private static SyntaxType register(String id, String name) {
        SyntaxType syntaxType = new SyntaxType(id, name);
        KNOWN_SYNTAX_TYPES.put(id, syntaxType);
        return syntaxType;
    }

    public static Map<String, SyntaxType> getSyntaxTypes() {
        return KNOWN_SYNTAX_TYPES;
    }

    public SyntaxType(String id, String name) {
        this.name = name;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.getId() ? 0 : this.getId().hashCode());
        return hash;
    }

    public boolean equals(Object object) {
        boolean result;
        if (this == object) {
            result = true;
        } else if (object == null || object.getClass() != this.getClass()) {
            result = false;
        } else {
            SyntaxType syntaxType = (SyntaxType)object;
            result = this.getId() == syntaxType.getId() || this.getId() != null && this.getId().equals(syntaxType.getId());
        }
        return result;
    }
}

