/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.stability.Unstable;

public class ParserUtils {
    public void removeTopLevelParagraph(List<Block> blocks) {
        if (blocks.size() == 1 && blocks.get(0) instanceof ParagraphBlock) {
            Block paragraphBlock = blocks.remove(0);
            blocks.addAll(0, paragraphBlock.getChildren());
            for (Block block : blocks) {
                block.setParent(null);
            }
        }
    }

    @Unstable
    public Block convertToInline(Block rootBlock, boolean preserveXDOM) {
        List<Block> blocks = rootBlock instanceof XDOM || rootBlock instanceof CompositeBlock ? new ArrayList<Block>(rootBlock.getChildren()) : Arrays.asList(rootBlock);
        this.convertToInline(blocks);
        if (preserveXDOM && rootBlock instanceof XDOM) {
            rootBlock.setChildren(blocks);
            return rootBlock;
        }
        return blocks.size() == 1 ? blocks.get(0) : new CompositeBlock(blocks);
    }

    @Unstable
    public void convertToInline(List<Block> blocks) {
        if (!blocks.isEmpty()) {
            MacroBlock macro;
            this.removeTopLevelParagraph(blocks);
            Block block = blocks.get(0);
            if (block instanceof MacroBlock && !(macro = (MacroBlock)block).isInline()) {
                blocks.set(0, new MacroBlock(macro.getId(), macro.getParameters(), macro.getContent(), true));
            }
        }
    }
}

