/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener.chaining;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.StackableChainingListener;

public class ListenerChain {
    private Map<Class<? extends ChainingListener>, Deque<ChainingListener>> listeners = new HashMap<Class<? extends ChainingListener>, Deque<ChainingListener>>();
    private List<Class<? extends ChainingListener>> nextListeners = new ArrayList<Class<? extends ChainingListener>>();

    public void addListener(ChainingListener listener) {
        this.addListener(listener, -1);
    }

    public void removeListener(Class<? extends ChainingListener> listenerClass) {
        Deque<ChainingListener> stack = this.listeners.get(listenerClass);
        if (stack.size() > 0) {
            stack.pop();
        }
        if (stack.isEmpty()) {
            this.listeners.remove(listenerClass);
            this.nextListeners.remove(listenerClass);
        }
    }

    public void addListener(ChainingListener listener, int index) {
        Deque<ChainingListener> stack = this.listeners.get(listener.getClass());
        if (stack == null) {
            stack = new ArrayDeque<ChainingListener>();
            this.listeners.put(listener.getClass(), stack);
            if (index > -1 && index < this.nextListeners.size()) {
                this.nextListeners.add(index, listener.getClass());
            } else {
                this.nextListeners.add(listener.getClass());
            }
        }
        stack.push(listener);
    }

    public ChainingListener getNextListener(Class<? extends ChainingListener> listenerClass) {
        ChainingListener next = null;
        int pos = this.indexOf(listenerClass);
        if (pos > -1 && this.nextListeners.size() > pos + 1) {
            next = this.listeners.get(this.nextListeners.get(pos + 1)).peek();
        }
        return next;
    }

    public ChainingListener getListener(Class<? extends ChainingListener> listenerClass) {
        Deque<ChainingListener> result = this.listeners.get(listenerClass);
        if (result == null) {
            for (Class<? extends ChainingListener> listenerKey : this.listeners.keySet()) {
                if (!listenerClass.isAssignableFrom(listenerKey)) continue;
                result = this.listeners.get(listenerKey);
                break;
            }
        }
        return result.peek();
    }

    public int indexOf(Class<? extends ChainingListener> listenerClass) {
        return this.nextListeners.indexOf(listenerClass);
    }

    public void pushListener(Class<? extends ChainingListener> listenerClass) {
        if (StackableChainingListener.class.isAssignableFrom(listenerClass)) {
            Deque<ChainingListener> stack = this.listeners.get(listenerClass);
            stack.push(((StackableChainingListener)stack.peek()).createChainingListenerInstance());
        }
    }

    public void pushAllStackableListeners() {
        for (Class<? extends ChainingListener> listenerClass : this.listeners.keySet()) {
            this.pushListener(listenerClass);
        }
    }

    public void popAllStackableListeners() {
        for (Class<? extends ChainingListener> listenerClass : this.listeners.keySet()) {
            this.popListener(listenerClass);
        }
    }

    public void popListener(Class<? extends ChainingListener> listenerClass) {
        if (StackableChainingListener.class.isAssignableFrom(listenerClass)) {
            this.listeners.get(listenerClass).pop();
        }
    }
}

