/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.reference.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.parser.reference.type.AbstractURIResourceReferenceTypeParser;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Named(value="url")
@Singleton
public class URLResourceReferenceTypeParser
extends AbstractURIResourceReferenceTypeParser {
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("[a-zA-Z0-9+.-]*://");

    @Override
    public ResourceType getType() {
        return ResourceType.URL;
    }

    @Override
    public ResourceReference parse(String reference) {
        ResourceReference resultReference = null;
        Matcher matcher = URL_SCHEME_PATTERN.matcher(reference);
        if (matcher.lookingAt()) {
            resultReference = new ResourceReference(reference, this.getType());
        }
        return resultReference;
    }
}

