/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.reference;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.reference.AbstractResourceReferenceParser;
import org.xwiki.rendering.listener.reference.InterWikiResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.ResourceReferenceTypeParser;

@Component
@Named(value="default/link")
@Singleton
public class GenericLinkReferenceParser
extends AbstractResourceReferenceParser {
    public static final String SEPARATOR_INTERWIKI = "@";
    public static final String SEPARATOR_QUERYSTRING = "?";
    public static final String SEPARATOR_ANCHOR = "#";
    public static final char ESCAPE_CHAR = '\\';
    private static final String[] ESCAPES_REFERENCE = new String[]{"\\?", "\\@", "\\#"};
    private static final String[] ESCAPES_EXTRA = new String[]{"\\?", "\\@", "\\#", String.valueOf('\\') + '\\'};
    private static final String[] ESCAPE_INTERWIKI = new String[]{String.valueOf('\\') + '\\', String.valueOf('\\')};
    private static final String[] ESCAPE_REPLACEMENTS_REFERENCE = new String[]{"?", "@", "#"};
    private static final String[] ESCAPE_REPLACEMENTS_EXTRA = new String[]{"?", "@", "#", String.valueOf('\\')};
    private static final String[] ESCAPE_REPLACEMENTS_INTERWIKI = new String[]{String.valueOf('\\'), ""};
    private static final List<String> URI_PREFIXES = Arrays.asList("mailto");
    @Inject
    @Named(value="url")
    private ResourceReferenceTypeParser urlResourceReferenceTypeParser;
    @Inject
    @Named(value="link/untyped")
    private ResourceReferenceParser untypedLinkReferenceParser;

    protected List<String> getAllowedURIPrefixes() {
        return URI_PREFIXES;
    }

    @Override
    public ResourceReference parse(String rawReference) {
        ResourceReference resourceReference = this.parseURILinks(rawReference);
        if (resourceReference != null) {
            return resourceReference;
        }
        StringBuilder content = new StringBuilder(rawReference);
        resourceReference = this.parseInterWikiLinks(content);
        if (resourceReference != null) {
            return resourceReference;
        }
        if (!this.isInWikiMode()) {
            resourceReference = new ResourceReference(rawReference, ResourceType.URL);
            resourceReference.setTyped(false);
            return resourceReference;
        }
        return this.parseDocumentLink(content);
    }

    private ResourceReference parseDocumentLink(StringBuilder content) {
        String queryString = null;
        String text = this.parseElementAfterString(content, SEPARATOR_QUERYSTRING);
        if (text != null) {
            queryString = this.removeEscapesFromExtraParts(text);
        }
        String anchor = null;
        text = this.parseElementAfterString(content, SEPARATOR_ANCHOR);
        if (text != null) {
            anchor = this.removeEscapesFromExtraParts(text);
        }
        String unescapedReferenceString = this.removeEscapesFromReferencePart(content.toString());
        ResourceReference reference = this.untypedLinkReferenceParser.parse(unescapedReferenceString);
        reference.setTyped(false);
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            reference.setParameter("queryString", queryString);
        }
        if (StringUtils.isNotBlank((CharSequence)anchor)) {
            reference.setParameter("anchor", anchor);
        }
        return reference;
    }

    private ResourceReference parseURILinks(String rawLink) {
        ResourceReference result = null;
        int uriSchemeDelimiterPos = rawLink.indexOf(58);
        if (uriSchemeDelimiterPos > -1) {
            String scheme = rawLink.substring(0, uriSchemeDelimiterPos);
            String reference = rawLink.substring(uriSchemeDelimiterPos + 1);
            if (this.getAllowedURIPrefixes().contains(scheme)) {
                try {
                    ResourceReferenceTypeParser parser = (ResourceReferenceTypeParser)((ComponentManager)this.componentManagerProvider.get()).getInstance(ResourceReferenceTypeParser.class, scheme);
                    ResourceReference resourceReference = parser.parse(reference);
                    if (resourceReference != null) {
                        result = resourceReference;
                    }
                }
                catch (ComponentLookupException parser) {}
            } else {
                ResourceReference resourceReference = this.urlResourceReferenceTypeParser.parse(rawLink);
                if (resourceReference != null) {
                    resourceReference.setTyped(false);
                    result = resourceReference;
                }
            }
        }
        return result;
    }

    private ResourceReference parseInterWikiLinks(StringBuilder content) {
        InterWikiResourceReference result = null;
        String interWikiAlias = this.parseElementAfterString(content, SEPARATOR_INTERWIKI);
        if (interWikiAlias != null) {
            InterWikiResourceReference link = new InterWikiResourceReference(this.removeEscapes(content.toString()));
            link.setInterWikiAlias(this.removeEscapes(interWikiAlias));
            result = link;
        }
        return result;
    }

    protected String parseElementAfterString(StringBuilder content, String separator) {
        String element = null;
        int index = content.lastIndexOf(separator);
        while (index != -1) {
            if (!this.shouldEscape(content, index)) {
                element = content.substring(index + separator.length()).trim();
                content.delete(index, content.length());
                break;
            }
            if (index <= 0) break;
            index = content.lastIndexOf(separator, index - 1);
        }
        return element;
    }

    private boolean shouldEscape(StringBuilder content, int charPosition) {
        int counter = 0;
        for (int pos = charPosition - 1; pos > -1 && content.charAt(pos) == '\\'; --pos) {
            ++counter;
        }
        return counter % 2 != 0;
    }

    private String removeEscapesFromReferencePart(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_REFERENCE, (String[])ESCAPE_REPLACEMENTS_REFERENCE);
    }

    private String removeEscapesFromExtraParts(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_EXTRA, (String[])ESCAPE_REPLACEMENTS_EXTRA);
    }

    private String removeEscapes(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPE_INTERWIKI, (String[])ESCAPE_REPLACEMENTS_INTERWIKI);
    }
}

