/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.script.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.script.ScriptContextInitializer;
import org.xwiki.script.ScriptContextManager;

@Component
@Singleton
public class DefaultScriptContextManager
implements ScriptContextManager {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    @Override
    public ScriptContext getScriptContext() {
        ScriptContext context = this.getCurrentScriptContext();
        if (context != null) {
            for (ScriptContextInitializer scriptContextInitializer : this.getScriptContextInitializers()) {
                try {
                    scriptContextInitializer.initialize(context);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to initialize the script context with [{}]. Root cause is [{}].", (Object)scriptContextInitializer, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
        }
        return context;
    }

    private List<ScriptContextInitializer> getScriptContextInitializers() {
        try {
            return ((ComponentManager)this.contextComponentManagerProvider.get()).getInstanceList(ScriptContextInitializer.class);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to get the list of script context initializers. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }

    @Override
    public ScriptContext getCurrentScriptContext() {
        ExecutionContext executionContext = this.execution.getContext();
        if (executionContext != null) {
            return (ScriptContext)executionContext.getProperty("scriptContext");
        }
        return null;
    }
}

