/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;

public class ExtendedJarURLConnection
extends JarURLConnection {
    private final URLStreamHandler handler;
    private final File jarsDirectory;
    private URL jarFileURL;
    private String entryName;
    private JarFile jarFile;
    private JarEntry jarEntry;

    public ExtendedJarURLConnection(URL url, URLStreamHandler handler, File jarsDirectory) throws MalformedURLException {
        super(new URL("jar:file:file.jar!/"));
        this.handler = handler;
        this.jarsDirectory = jarsDirectory;
        this.parseSpecs(url);
    }

    private void createJarFile() throws IOException {
        this.jarsDirectory.mkdirs();
        final File tempFile = File.createTempFile("jar", ".jar", this.jarsDirectory);
        try (InputStream stream = this.jarFileURL.openStream();){
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tempFile);
        }
        this.jarFile = new JarFile(tempFile){

            @Override
            public void close() throws IOException {
                super.close();
                tempFile.delete();
            }
        };
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.createJarFile();
            if (this.entryName != null) {
                this.jarEntry = (JarEntry)this.jarFile.getEntry(this.entryName);
                if (this.jarEntry == null) {
                    try {
                        this.jarFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    @Override
    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.jarFile.getInputStream(this.jarEntry);
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.getJarFileURL().openConnection().getPermission();
    }

    private void parseSpecs(URL url) throws MalformedURLException {
        String spec = url.getFile();
        int separator = spec.indexOf("!/");
        if (separator == -1) {
            throw new MalformedURLException("no !/ found in url spec:" + spec);
        }
        this.jarFileURL = new URL(null, spec.substring(0, separator++), this.handler);
        this.entryName = null;
        if (++separator != spec.length()) {
            this.entryName = spec.substring(separator, spec.length());
            try {
                this.entryName = URLDecoder.decode(this.entryName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to URL decode [" + this.entryName + "] using UTF-8.", e);
            }
        }
    }
}

