/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.classloader.ExtendedURLStreamHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

@Component(roles={URLStreamHandlerFactory.class})
@Singleton
public class ExtendedURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.componentManager.hasComponent(ExtendedURLStreamHandler.class, protocol)) {
            try {
                return (URLStreamHandler)this.componentManager.getInstance(ExtendedURLStreamHandler.class, protocol);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup ExtendedURLStreamHandler or protocol [{}]", (Object)protocol, (Object)e);
            }
        }
        return null;
    }
}

