/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display;

import java.util.ArrayList;
import org.xwiki.diff.display.UnifiedDiffElement;
import org.xwiki.stability.Unstable;

public class UnifiedDiffBlock<E, F>
extends ArrayList<UnifiedDiffElement<E, F>> {
    private static final long serialVersionUID = 1L;

    public int getPreviousStart() {
        for (UnifiedDiffElement element : this) {
            if (element.isAdded()) continue;
            return element.getIndex();
        }
        return 0;
    }

    public int getPreviousSize() {
        int size = 0;
        for (UnifiedDiffElement element : this) {
            if (element.isAdded()) continue;
            ++size;
        }
        return size;
    }

    public int getNextStart() {
        for (UnifiedDiffElement element : this) {
            if (element.isDeleted()) continue;
            return element.getIndex();
        }
        return 0;
    }

    public int getNextSize() {
        int size = 0;
        for (UnifiedDiffElement element : this) {
            if (element.isDeleted()) continue;
            ++size;
        }
        return size;
    }

    @Unstable
    public boolean isConflicting() {
        for (UnifiedDiffElement element : this) {
            if (!element.isConflicting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("@@ -%s,%s +%s,%s @@\n", this.getPreviousStart() + 1, this.getPreviousSize(), this.getNextStart() + 1, this.getNextSize()));
        for (UnifiedDiffElement element : this) {
            stringBuilder.append(element);
        }
        return stringBuilder.toString();
    }
}

