/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import java.util.Stack;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

public class StackingComponentEventManager
implements ComponentEventManager {
    private ObservationManager observationManager;
    private Stack<ComponentEventEntry> events = new Stack();
    private boolean shouldStack = true;

    public void notifyComponentRegistered(ComponentDescriptor<?> descriptor) {
        this.notifyComponentEvent((Event)new ComponentDescriptorAddedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor, null);
    }

    public void notifyComponentRegistered(ComponentDescriptor<?> descriptor, ComponentManager componentManager) {
        this.notifyComponentEvent((Event)new ComponentDescriptorAddedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor, componentManager);
    }

    public void notifyComponentUnregistered(ComponentDescriptor<?> descriptor) {
        this.notifyComponentEvent((Event)new ComponentDescriptorRemovedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor, null);
    }

    public void notifyComponentUnregistered(ComponentDescriptor<?> descriptor, ComponentManager componentManager) {
        this.notifyComponentEvent((Event)new ComponentDescriptorRemovedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor, componentManager);
    }

    public synchronized void flushEvents() {
        for (ComponentEventEntry entry : this.events) {
            this.sendEvent(entry.event, entry.descriptor, entry.componentManager);
        }
    }

    public void shouldStack(boolean shouldStack) {
        this.shouldStack = shouldStack;
    }

    public void setObservationManager(ObservationManager observationManager) {
        this.observationManager = observationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyComponentEvent(Event event, ComponentDescriptor<?> descriptor, ComponentManager componentManager) {
        if (this.shouldStack) {
            StackingComponentEventManager stackingComponentEventManager = this;
            synchronized (stackingComponentEventManager) {
                this.events.push(new ComponentEventEntry(event, descriptor, componentManager));
            }
        } else {
            this.sendEvent(event, descriptor, componentManager);
        }
    }

    private void sendEvent(Event event, ComponentDescriptor<?> descriptor, ComponentManager componentManager) {
        if (this.observationManager != null) {
            this.observationManager.notify(event, (Object)componentManager, descriptor);
        }
    }

    static class ComponentEventEntry {
        public Event event;
        public ComponentDescriptor<?> descriptor;
        public ComponentManager componentManager;

        public ComponentEventEntry(Event event, ComponentDescriptor<?> descriptor, ComponentManager componentManager) {
            this.event = event;
            this.descriptor = descriptor;
            this.componentManager = componentManager;
        }
    }
}

