/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class ReflectionMethodUtils {
    private ReflectionMethodUtils() {
    }

    public static <A extends Annotation> List<A> getMethodParameterAnnotations(Method method, int index, Class<A> annotationClass) {
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        Annotation[] parameterAnnotations = parametersAnnotations[index];
        ArrayList<Annotation> foundAnnotations = new ArrayList<Annotation>();
        for (Annotation annotation : parameterAnnotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            foundAnnotations.add(annotation);
        }
        return foundAnnotations;
    }

    public static <A extends Annotation> List<A> getMethodParameterAnnotations(Method method, int index, Class<A> annotationClass, boolean inherits) {
        List<A> annotations = ReflectionMethodUtils.getMethodParameterAnnotations(method, index, annotationClass);
        if (inherits && annotationClass.getAnnotation(Inherited.class) != null) {
            Class<?>[] ifaces;
            for (Class<?> iface : ifaces = method.getDeclaringClass().getInterfaces()) {
                try {
                    Method interfaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                    if (interfaceMethod == null) continue;
                    annotations.addAll(ReflectionMethodUtils.getMethodParameterAnnotations(interfaceMethod, index, annotationClass, true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class<?> superClass = method.getDeclaringClass().getSuperclass();
            if (superClass != null) {
                try {
                    Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
                    if (superMethod != null) {
                        annotations.addAll(ReflectionMethodUtils.getMethodParameterAnnotations(superMethod, index, annotationClass, true));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return annotations;
    }
}

