/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.internal;

import java.util.HashMap;
import java.util.Map;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheEntry;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.util.AbstractCache;

public class MapCache<T>
extends AbstractCache<T> {
    private Map<String, T> map = new HashMap<String, T>();

    public MapCache() {
        super(null);
    }

    private CacheEntryEvent<T> toEvent(final String key, final T value) {
        return new CacheEntryEvent<T>(){

            @Override
            public CacheEntry<T> getEntry() {
                return new MapCacheEntry(key, value);
            }

            @Override
            public Cache<T> getCache() {
                return MapCache.this;
            }
        };
    }

    @Override
    public void set(String key, T value) {
        this.map.put(key, value);
        this.sendEntryAddedEvent(this.toEvent(key, value));
    }

    @Override
    public T get(String key) {
        return this.map.get(key);
    }

    @Override
    public void remove(String key) {
        if (this.map.containsKey(key)) {
            T value = this.map.remove(key);
            this.sendEntryRemovedEvent(this.toEvent(key, value));
        } else {
            this.map.remove(key);
        }
    }

    @Override
    public void removeAll() {
        this.map.clear();
        HashMap<String, T> eventMap = new HashMap<String, T>(this.map);
        for (Map.Entry entry : eventMap.entrySet()) {
            this.sendEntryRemovedEvent(this.toEvent((String)entry.getKey(), entry.getValue()));
        }
    }

    public String toString() {
        return this.map.toString();
    }

    class MapCacheEntry
    implements CacheEntry<T> {
        private final String key;
        private final T value;

        MapCacheEntry(String key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Cache<T> getCache() {
            return MapCache.this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

