/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IIoConnectorCallback;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.MonitoredSelector;

final class IoConnector
extends MonitoredSelector
implements Runnable,
Closeable {
    private static final Logger LOG = Logger.getLogger(IoConnector.class.getName());
    static final String CONNECTOR_PREFIX = "xConnector";
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private static final long DEFAULT_WATCHDOG_PERIOD_MILLIS = 60000L;
    private long watchDogPeriodMillis = 60000L;
    private final TimeoutCheckTask timeoutCheckTask = new TimeoutCheckTask();
    private TimerTask watchDogTask;
    private final Selector selector;
    private final String name;
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();

    public IoConnector(String name) {
        this.name = "xConnector#" + name;
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
    }

    void reinit() throws IOException {
    }

    public void run() {
        block7: {
            Thread.currentThread().setName(this.name);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("selector " + this.name + " listening ...");
            }
            int handledTasks = 0;
            while (this.isOpen.get()) {
                try {
                    handledTasks = this.performTaskQueue();
                    int eventCount = this.selector.select(1000L);
                    if (eventCount > 0) {
                        this.handleConnect();
                        continue;
                    }
                    this.checkForLooping(handledTasks);
                }
                catch (Exception e) {
                    LOG.warning("[" + Thread.currentThread().getName() + "] exception occured while processing. Reason " + DataConverter.toString(e));
                }
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by close selector within tearDown " + DataConverter.toString(e));
            }
        }
    }

    String printRegistered() {
        StringBuilder sb = new StringBuilder();
        HashSet<SelectionKey> keys = new HashSet<SelectionKey>();
        keys.addAll(this.selector.keys());
        for (SelectionKey key : keys) {
            sb.append(ConnectionUtils.printSelectionKey(key) + "\r\n");
        }
        return sb.toString();
    }

    int getNumRegisteredHandles() {
        return this.selector.keys().size();
    }

    public void close() throws IOException {
        this.isOpen.set(false);
    }

    private int performTaskQueue() throws IOException {
        int handledTasks = 0;
        Runnable task;
        while ((task = this.taskQueue.poll()) != null) {
            task.run();
            ++handledTasks;
        }
        return handledTasks;
    }

    private void handleConnect() {
        Set<SelectionKey> selectedEventKeys = this.selector.selectedKeys();
        Iterator<SelectionKey> it = selectedEventKeys.iterator();
        while (it.hasNext()) {
            SelectionKey eventKey = it.next();
            it.remove();
            RegisterTask registerTask = (RegisterTask)eventKey.attachment();
            if (!eventKey.isValid() || !eventKey.isConnectable()) continue;
            try {
                boolean isConnected = ((SocketChannel)eventKey.channel()).finishConnect();
                if (!isConnected) continue;
                eventKey.cancel();
                registerTask.callback.onConnectionEstablished();
            }
            catch (IOException ioe) {
                block6: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by performing handling connect event " + ioe.toString());
                    }
                    try {
                        eventKey.channel().close();
                    }
                    catch (IOException e) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.fine("error occured by closing channel " + e.toString());
                    }
                }
                registerTask.callback.onConnectError(ioe);
            }
        }
    }

    public void connectAsync(SocketChannel channel, InetSocketAddress remoteAddress, long connectTimeoutMillis, IIoConnectorCallback callback) throws IOException {
        assert (channel.isOpen());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("try to connect " + remoteAddress + " (connect timeout " + DataConverter.toFormatedDuration(connectTimeoutMillis) + ")");
        }
        RegisterTask registerTask = new RegisterTask(channel, callback, remoteAddress, System.currentTimeMillis() + connectTimeoutMillis);
        this.addToTaskQueue(registerTask);
        if (connectTimeoutMillis >= 1000L) {
            this.updateTimeoutCheckPeriod(connectTimeoutMillis / 5L);
        } else {
            this.updateTimeoutCheckPeriod(200L);
        }
    }

    private void addToTaskQueue(Runnable task) {
        this.taskQueue.add(task);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimeoutCheckPeriod(long requiredMinPeriod) {
        IoConnector ioConnector = this;
        synchronized (ioConnector) {
            if (this.watchDogTask != null && this.watchDogPeriodMillis <= requiredMinPeriod) {
                return;
            }
            this.watchDogPeriodMillis = requiredMinPeriod;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("update watchdog period " + DataConverter.toFormatedDuration(this.watchDogPeriodMillis));
            }
            if (this.watchDogTask != null) {
                this.watchDogTask.cancel();
                this.watchDogTask = null;
            }
            this.watchDogTask = new TimerTask(){

                public void run() {
                    IoConnector.this.addToTaskQueue(IoConnector.this.timeoutCheckTask);
                }
            };
            IoProvider.getTimer().schedule(this.watchDogTask, this.watchDogPeriodMillis, this.watchDogPeriodMillis);
        }
    }

    private final class TimeoutCheckTask
    implements Runnable {
        private TimeoutCheckTask() {
        }

        public void run() {
            block3: {
                try {
                    long currentMillis = System.currentTimeMillis();
                    for (SelectionKey selectionKey : IoConnector.this.selector.keys()) {
                        RegisterTask registerTask = (RegisterTask)selectionKey.attachment();
                        if (!registerTask.isExpired(currentMillis)) continue;
                        selectionKey.cancel();
                        registerTask.callback.onConnectTimeout();
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by performing timeout check task " + e.toString());
                }
            }
        }
    }

    private final class RegisterTask
    implements Runnable {
        private final SocketChannel channel;
        private final IIoConnectorCallback callback;
        private final InetSocketAddress remoteAddress;
        private final long expireTime;
        private SelectionKey selectionKey;

        public RegisterTask(SocketChannel channel, IIoConnectorCallback callback, InetSocketAddress remoteAddress, long expireTime) throws IOException {
            this.channel = channel;
            this.callback = callback;
            this.remoteAddress = remoteAddress;
            this.expireTime = expireTime;
            channel.configureBlocking(false);
        }

        boolean isExpired(long currentTime) {
            return currentTime > this.expireTime;
        }

        public void run() {
            this.selectionKey = null;
            try {
                this.selectionKey = this.channel.register(IoConnector.this.selector, 8);
                this.selectionKey.attach(this);
                this.connect(this.channel, this.remoteAddress);
            }
            catch (IOException ioe) {
                block6: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by registering channel " + this.channel + " reason " + ioe.toString());
                    }
                    if (this.selectionKey != null) {
                        this.selectionKey.cancel();
                    }
                    try {
                        this.channel.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.fine("error occured by closing channel " + e.toString());
                    }
                }
                this.callback.onConnectError(ioe);
            }
        }

        private void connect(SocketChannel channel, InetSocketAddress remoteAddress) throws IOException {
            try {
                channel.connect(remoteAddress);
            }
            catch (UnresolvedAddressException uae) {
                throw new IOException("connecting " + remoteAddress + " failed " + uae.toString());
            }
        }
    }
}

