/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConnectionManager {
    private static final Logger LOG = Logger.getLogger(ConnectionManager.class.getName());
    private final ArrayList<WeakReference<TimeoutMgmHandle>> handles = new ArrayList();
    private static final long DEFAULT_WATCHDOG_PERIOD_CONNECTION_CHECK_MILLISTION_CHECK_MILLIS = 60000L;
    private long watchDogPeriodConCheckMillis = 60000L;
    private WachdogTask conCheckWatchDogTask = null;
    private int watchDogRuns;
    private int countIdleTimeouts;
    private int countConnectionTimeouts;
    private AtomicInteger currentSize = new AtomicInteger(0);

    public ConnectionManager() {
        this.updateTimeoutCheckPeriod(this.watchDogPeriodConCheckMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutMgmHandle register(NonBlockingConnection connection) {
        TimeoutMgmHandle mgnCon = new TimeoutMgmHandle(connection);
        WeakReference<TimeoutMgmHandle> ref = mgnCon.getWeakRef();
        if (ref != null) {
            ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
            synchronized (arrayList) {
                this.handles.add(ref);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("did not get the weak ref");
        }
        this.currentSize.incrementAndGet();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection registered");
        }
        return mgnCon;
    }

    long getWatchDogPeriodMillis() {
        return this.watchDogPeriodConCheckMillis;
    }

    int getWatchDogRuns() {
        return this.watchDogRuns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(WeakReference<TimeoutMgmHandle> handleRef) {
        NonBlockingConnection con;
        TimeoutMgmHandle hdl;
        ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
        synchronized (arrayList) {
            this.handles.remove(handleRef);
        }
        this.currentSize.decrementAndGet();
        if (LOG.isLoggable(Level.FINE) && (hdl = (TimeoutMgmHandle)handleRef.get()) != null && (con = hdl.getConnection()) != null) {
            LOG.fine("[" + con.getId() + "] handle deregistered (connections size=" + this.computeSize() + ")");
        }
    }

    int getSize() {
        return this.currentSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeSize() {
        ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
        synchronized (arrayList) {
            int size = this.handles.size();
            this.currentSize.set(size);
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<NonBlockingConnection> getConnections() {
        HashSet<NonBlockingConnection> cons = new HashSet<NonBlockingConnection>();
        ArrayList connectionsCopy = null;
        ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
        synchronized (arrayList) {
            connectionsCopy = (ArrayList)this.handles.clone();
        }
        for (WeakReference handleRef : connectionsCopy) {
            NonBlockingConnection con;
            TimeoutMgmHandle handle = (TimeoutMgmHandle)handleRef.get();
            if (handle == null || (con = handle.getConnection()) == null) continue;
            cons.add(con);
        }
        return cons;
    }

    void close() {
        block6: {
            if (this.conCheckWatchDogTask != null) {
                this.conCheckWatchDogTask.cancel();
                this.conCheckWatchDogTask = null;
            }
            try {
                for (NonBlockingConnection connection : this.getConnections()) {
                    try {
                        connection.close();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("error occured by closing connection " + connection.getId() + " " + DataConverter.toString(ioe));
                    }
                }
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.FINE)) break block6;
                LOG.fine("error occured by closing open connections " + DataConverter.toString(e));
            }
        }
        this.handles.clear();
    }

    int getNumberOfIdleTimeouts() {
        return this.countIdleTimeouts;
    }

    int getNumberOfConnectionTimeouts() {
        return this.countConnectionTimeouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimeoutCheckPeriod(long requiredMinPeriod) {
        if (this.conCheckWatchDogTask != null && this.watchDogPeriodConCheckMillis <= requiredMinPeriod) {
            return;
        }
        this.watchDogPeriodConCheckMillis = requiredMinPeriod;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("update watchdog period " + DataConverter.toFormatedDuration(this.watchDogPeriodConCheckMillis));
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.conCheckWatchDogTask != null) {
                WachdogTask tt = this.conCheckWatchDogTask;
                this.conCheckWatchDogTask = null;
                tt.cancel();
            }
            this.conCheckWatchDogTask = new WachdogTask();
            IoProvider.getTimer().schedule((TimerTask)this.conCheckWatchDogTask, this.watchDogPeriodConCheckMillis, this.watchDogPeriodConCheckMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check() {
        ++this.watchDogRuns;
        long current = System.currentTimeMillis();
        ArrayList connectionsCopy = null;
        ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
        synchronized (arrayList) {
            connectionsCopy = (ArrayList)this.handles.clone();
        }
        for (WeakReference handleRef : connectionsCopy) {
            TimeoutMgmHandle handle = (TimeoutMgmHandle)handleRef.get();
            if (handle == null) {
                this.remove(handleRef);
                continue;
            }
            NonBlockingConnection con = handle.getConnection();
            if (con.isOpen()) {
                this.checkTimeout(con, current);
                continue;
            }
            this.remove(handleRef);
        }
        this.computeSize();
    }

    private void checkTimeout(NonBlockingConnection connection, long current) {
        boolean timeoutOccured = connection.checkIdleTimeout(current);
        if (timeoutOccured) {
            ++this.countIdleTimeouts;
        }
        if (timeoutOccured = connection.checkConnectionTimeout(current)) {
            ++this.countConnectionTimeouts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class TimeoutMgmHandle {
        private final NonBlockingConnection con;
        private WeakReference<TimeoutMgmHandle> handleRef;

        public TimeoutMgmHandle(NonBlockingConnection connection) {
            this.con = connection;
            this.handleRef = new WeakReference<TimeoutMgmHandle>(this);
        }

        WeakReference<TimeoutMgmHandle> getWeakRef() {
            return this.handleRef;
        }

        void updateCheckPeriod(long period) {
            ConnectionManager.this.updateTimeoutCheckPeriod(period);
        }

        void destroy() {
            if (this.handleRef != null) {
                ConnectionManager.this.remove(this.handleRef);
                this.handleRef = null;
            }
        }

        NonBlockingConnection getConnection() {
            return this.con;
        }
    }

    private final class WachdogTask
    extends TimerTask {
        private WachdogTask() {
        }

        public void run() {
            block2: {
                try {
                    ConnectionManager.this.check();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by running check: " + e.toString());
                }
            }
        }
    }
}

