/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;

class MemoryManager {
    private static final Logger LOG = Logger.getLogger(MemoryManager.class.getName());
    private List<SoftReference<ByteBuffer>> memoryBuffer = new ArrayList<SoftReference<ByteBuffer>>();
    private boolean useDirectMemory = false;
    private int preallocationSize = 4096;

    MemoryManager(int preallocationSize, boolean useDirectMemory) {
        this.preallocationSize = preallocationSize;
        this.useDirectMemory = useDirectMemory;
    }

    public final synchronized int getFreeBufferSize() {
        int size = 0;
        for (SoftReference<ByteBuffer> bufferRef : this.memoryBuffer) {
            ByteBuffer buffer = bufferRef.get();
            if (buffer == null) continue;
            size += buffer.remaining();
        }
        return size;
    }

    private void recycleMemory(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            this.memoryBuffer.add(new SoftReference<ByteBuffer>(buffer.slice()));
        }
    }

    public final synchronized ByteBuffer acquireMemory(int size) {
        SoftReference<ByteBuffer> freeBuffer;
        Buffer buffer = null;
        if (!this.memoryBuffer.isEmpty() && (buffer = (freeBuffer = this.memoryBuffer.remove(0)).get()) != null && buffer.limit() < size) {
            buffer = null;
        }
        if (buffer == null) {
            int allocationSize = this.getPreallocationSize();
            if (this.getPreallocationSize() < allocationSize) {
                allocationSize = size * 4;
            }
            buffer = this.newBuffer(size);
        }
        int savedLimit = buffer.limit();
        ((ByteBuffer)buffer).limit(size);
        ByteBuffer result = ((ByteBuffer)buffer).slice();
        ((ByteBuffer)buffer).position(size);
        ((ByteBuffer)buffer).limit(savedLimit);
        ByteBuffer remaining = ((ByteBuffer)buffer).slice();
        this.recycleMemory(remaining);
        return result;
    }

    int getPreallocationSize() {
        return this.preallocationSize;
    }

    private final ByteBuffer newBuffer(int size) {
        if (this.useDirectMemory) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("allocating " + DataConverter.toFormatedBytesSize(size) + " direct memory");
            }
            return ByteBuffer.allocateDirect(size);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("allocating " + DataConverter.toFormatedBytesSize(size) + " heap memory");
        }
        return ByteBuffer.allocate(size);
    }
}

