/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.datagram.AbstractChannelBasedEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcher
implements Runnable,
Closeable {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcher.class.getName());
    static final String DISPATCHER_PREFIX = "xDispatcher";
    private static final long TIMEOUT_SHUTDOWN_MILLIS = 5000L;
    private final Queue<AbstractChannelBasedEndpoint> registerQueue = new ConcurrentLinkedQueue<AbstractChannelBasedEndpoint>();
    private final Queue<AbstractChannelBasedEndpoint> deregisterQueue = new ConcurrentLinkedQueue<AbstractChannelBasedEndpoint>();
    private final Queue<KeyUpdateTask> keyUpdateQueue = new ConcurrentLinkedQueue<KeyUpdateTask>();
    private volatile boolean isOpen = true;
    private Selector selector = null;
    private long handledRegistractions = 0L;
    private long handledReads = 0L;
    private long handledWrites = 0L;

    public IoSocketDispatcher() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
    }

    @Override
    public final void run() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("selector  listening ...");
        }
        int handledTasks = 0;
        while (this.isOpen) {
            try {
                int eventCount = this.selector.select();
                handledTasks = this.performRegisterHandlerTasks();
                handledTasks += this.performKeyUpdateTasks();
                if (eventCount > 0) {
                    Set<SelectionKey> selectedEventKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> it = selectedEventKeys.iterator();
                    while (it.hasNext()) {
                        SelectionKey eventKey = it.next();
                        it.remove();
                        AbstractChannelBasedEndpoint handler = (AbstractChannelBasedEndpoint)eventKey.attachment();
                        if (eventKey.isValid() && eventKey.isReadable()) {
                            this.onReadableEvent(handler);
                        }
                        if (!eventKey.isValid() || !eventKey.isWritable()) continue;
                        this.onWriteableEvent(handler);
                    }
                }
                handledTasks += this.performDeregisterHandlerTasks();
            }
            catch (Exception e) {
                LOG.warning("[" + Thread.currentThread().getName() + "] exception occured while processing. Reason " + DataConverter.toString(e));
            }
        }
        this.closeDispatcher();
    }

    private void onReadableEvent(AbstractChannelBasedEndpoint handler) {
        try {
            handler.onReadableEvent();
        }
        catch (Exception e) {
            LOG.warning("[" + Thread.currentThread().getName() + "] exception occured while handling readable event. Reason " + DataConverter.toString(e));
        }
        ++this.handledReads;
    }

    private void onWriteableEvent(AbstractChannelBasedEndpoint handler) {
        try {
            handler.onWriteableEvent();
        }
        catch (Exception e) {
            LOG.warning("[" + Thread.currentThread().getName() + "] exception occured while handling writeable event. Reason " + DataConverter.toString(e));
        }
        ++this.handledWrites;
    }

    public void register(AbstractChannelBasedEndpoint handler) {
        assert (!handler.getChannel().isBlocking());
        boolean isWakeUpRequired = false;
        if (this.registerQueue.isEmpty()) {
            isWakeUpRequired = true;
        }
        this.registerQueue.offer(handler);
        if (isWakeUpRequired) {
            this.wakeUp();
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("does not wake up selector, because register queue handling is currently running");
        }
    }

    public void deregister(AbstractChannelBasedEndpoint handler) {
        boolean isWakeUpRequired = false;
        if (this.deregisterQueue.isEmpty()) {
            isWakeUpRequired = true;
        }
        this.deregisterQueue.offer(handler);
        if (isWakeUpRequired) {
            this.wakeUp();
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("does not wake up selector, because deregister queue handling is currently running");
        }
    }

    void wakeUp() {
        this.selector.wakeup();
    }

    void setSelectionKeyToReadImmediately(AbstractChannelBasedEndpoint handler) {
        SelectionKey key = handler.getChannel().keyFor(this.selector);
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        key.interestOps(key.interestOps() | 1);
    }

    private void setSelectionKeyToWriteImmediate(AbstractChannelBasedEndpoint handler) {
        SelectionKey key = handler.getChannel().keyFor(this.selector);
        key.interestOps(key.interestOps() | 4);
    }

    void initiateRead(final AbstractChannelBasedEndpoint handler) {
        KeyUpdateTask task = new KeyUpdateTask(handler){

            public void run() {
                IoSocketDispatcher.this.setSelectionKeyToReadImmediately(handler);
            }
        };
        this.keyUpdateQueue.add(task);
        this.wakeUp();
    }

    void initiateWrite(final AbstractChannelBasedEndpoint handler) {
        KeyUpdateTask task = new KeyUpdateTask(handler){

            public void run() {
                IoSocketDispatcher.this.setSelectionKeyToWriteImmediate(handler);
            }
        };
        this.keyUpdateQueue.add(task);
        this.wakeUp();
    }

    private int performRegisterHandlerTasks() throws IOException {
        AbstractChannelBasedEndpoint handler;
        int handledTasks = 0;
        while (true) {
            if ((handler = this.registerQueue.poll()) == null) {
                return handledTasks;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("registering handler " + handler);
            }
            if (!handler.getChannel().isOpen()) break;
            handler.getChannel().register(this.selector, 1, handler);
            ++this.handledRegistractions;
            ++handledTasks;
        }
        throw new IOException("channel " + handler.getId() + " is already closed. Could not register it");
    }

    private int performKeyUpdateTasks() {
        int handledTasks = 0;
        KeyUpdateTask keyUpdateTask;
        while ((keyUpdateTask = this.keyUpdateQueue.poll()) != null) {
            keyUpdateTask.init();
            if (keyUpdateTask.getKey() != null) {
                if (keyUpdateTask.getKey().isValid()) {
                    keyUpdateTask.run();
                } else {
                    keyUpdateTask.getKey().cancel();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("handler " + keyUpdateTask.getHandler() + " (key) is invalid. ignore it");
                    }
                }
            }
            ++handledTasks;
        }
        return handledTasks;
    }

    private int performDeregisterHandlerTasks() {
        int handledTasks = 0;
        AbstractChannelBasedEndpoint handler;
        while ((handler = this.deregisterQueue.poll()) != null) {
            SelectionKey key;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("registering handler " + handler);
            }
            if ((key = handler.getChannel().keyFor(this.selector)) != null && key.isValid()) {
                key.cancel();
            }
            ++handledTasks;
        }
        return handledTasks;
    }

    public final Set<AbstractChannelBasedEndpoint> getRegistered() {
        HashSet<AbstractChannelBasedEndpoint> registered = new HashSet<AbstractChannelBasedEndpoint>();
        Set<SelectionKey> keys = this.selector.keys();
        try {
            for (SelectionKey key : keys) {
                AbstractChannelBasedEndpoint handler = (AbstractChannelBasedEndpoint)key.attachment();
                registered.add(handler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return registered;
    }

    private void closeDispatcher() {
        block3: {
            LOG.fine("closing connections");
            if (this.selector != null) {
                try {
                    this.selector.close();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by close selector within tearDown " + DataConverter.toString(e));
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.selector != null) {
            Set<AbstractChannelBasedEndpoint> registered = this.getRegistered();
            for (AbstractChannelBasedEndpoint endpoint : registered) {
                endpoint.onDispatcherClose();
            }
            new Thread(new Closer(registered.size())).start();
        }
    }

    public final boolean isOpen() {
        return this.isOpen;
    }

    public long getNumberOfHandledRegistrations() {
        return this.handledRegistractions;
    }

    public long getNumberOfHandledReads() {
        return this.handledReads;
    }

    public long getNumberOfHandledWrites() {
        return this.handledWrites;
    }

    public String toString() {
        return "open channels  " + this.getRegistered().size();
    }

    private class Closer
    implements Runnable {
        private int openConnections = 0;

        public Closer(int openConnections) {
            this.openConnections = openConnections;
        }

        public void run() {
            Thread.currentThread().setName("xDispatcherCloser");
            long start = System.currentTimeMillis();
            int terminatedConnections = 0;
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= start + 5000L) continue;
                LOG.warning("shutdown timeout reached (" + DataConverter.toFormatedDuration(5000L) + "). kill pending connections");
                for (SelectionKey sk : IoSocketDispatcher.this.selector.keys()) {
                    try {
                        ++terminatedConnections;
                        sk.channel().close();
                    }
                    catch (Exception ignore) {}
                }
                break;
            } while (IoSocketDispatcher.this.getRegistered().size() > 0);
            IoSocketDispatcher.this.isOpen = false;
            IoSocketDispatcher.this.selector.wakeup();
            if ((this.openConnections > 0 || terminatedConnections > 0) && this.openConnections > 0 && terminatedConnections > 0) {
                LOG.info(this.openConnections - terminatedConnections + " connections has been closed properly, " + terminatedConnections + " connections has been terminate unclean");
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("dispatcher " + this.hashCode() + " has been closed (shutdown time = " + DataConverter.toFormatedDuration(System.currentTimeMillis() - start) + ")");
            }
        }
    }

    private class KeyUpdateTask
    implements Runnable {
        private AbstractChannelBasedEndpoint handler = null;
        private SelectionKey key = null;

        public KeyUpdateTask(AbstractChannelBasedEndpoint handler) {
            this.handler = handler;
        }

        void init() {
            this.key = this.handler.getChannel().keyFor(IoSocketDispatcher.this.selector);
        }

        AbstractChannelBasedEndpoint getHandler() {
            return this.handler;
        }

        SelectionKey getKey() {
            return this.key;
        }

        public void run() {
        }
    }
}

