/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoQueue;
import org.xsocket.connection.IoSSLHandler;
import org.xsocket.connection.IoSSLProcessor;

final class IoActivateableSSLHandler
extends IoChainableHandler
implements IoSSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private Mode mode = Mode.OFF;
    private IoQueue inNetDataQueue = new IoQueue();
    private IoQueue outAppDataQueue = new IoQueue();
    private final PendingWriteMap pendingWriteMap = new PendingWriteMap();
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private IoSSLProcessor sslProcessor = null;

    IoActivateableSSLHandler(IoChainableHandler successor, SSLContext sslContext, boolean isClientMode, AbstractMemoryManager memoryManager) throws IOException {
        super(successor);
        this.sslProcessor = new IoSSLProcessor(sslContext, isClientMode, memoryManager, this);
    }

    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
    }

    public boolean reset() {
        this.inNetDataQueue.drain();
        this.outAppDataQueue.drain();
        this.pendingWriteMap.clear();
        return super.reset();
    }

    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    public final void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.flushOutgoing();
        }
        this.getSuccessor().close(immediate);
    }

    public boolean isSSLActivated() {
        return this.mode == Mode.SSL;
    }

    public int getPendingWriteDataSize() {
        return this.outAppDataQueue.getSize() + super.getPendingWriteDataSize();
    }

    public boolean hasDataToSend() {
        return !this.outAppDataQueue.isEmpty() || super.hasDataToSend();
    }

    public final void write(ByteBuffer[] buffers) throws ClosedChannelException, IOException {
        this.outAppDataQueue.append(buffers);
        this.flushOutgoing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOutgoing() throws IOException {
        if (this.mode == Mode.SSL) {
            IoSSLProcessor ioSSLProcessor = this.sslProcessor;
            synchronized (ioSSLProcessor) {
                if (this.sslProcessor.isHandshaking()) {
                    this.sslProcessor.encrypt();
                } else if (!this.outAppDataQueue.isEmpty()) {
                    this.sslProcessor.encrypt(this.outAppDataQueue.drain());
                }
            }
        } else if (this.mode == Mode.OFF || this.mode == Mode.PLAIN_OUTGOING_SSL_INCOMING) {
            ByteBuffer[] data = this.outAppDataQueue.drain();
            this.getSuccessor().write(data);
        }
    }

    public boolean preStartSecuredMode() {
        if (this.mode == Mode.OFF) {
            this.mode = Mode.PLAIN_OUTGOING_SSL_INCOMING;
            return true;
        }
        LOG.warning("connection is already in ssl mode (mode=" + (Object)((Object)this.mode) + "). Ignore (pre)startSecured Mode");
        return false;
    }

    public void startSecuredMode(ByteBuffer[] data) throws IOException {
        if (this.mode != Mode.PLAIN_OUTGOING_SSL_INCOMING) {
            LOG.warning("connection is not in non_receiving mode (mode=" + (Object)((Object)this.mode) + ")");
            return;
        }
        this.mode = Mode.PRE_SSL2;
        if (data != null && data.length > 0) {
            this.inNetDataQueue.addFirst(data);
        }
        this.sslProcessor.start();
        this.mode = Mode.SSL;
        this.flushOutgoing();
        this.readIncomingEncryptedData(this.inNetDataQueue.drain());
    }

    public void onHandshakeFinished() throws IOException {
        this.flushOutgoing();
    }

    private synchronized void readIncomingEncryptedData(ByteBuffer[] inNetDataList) throws ClosedChannelException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : inNetDataList) {
                    size += buffer.remaining();
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessor.decrypt(inNetDataList);
        }
    }

    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    public void onDataDecrypted(ByteBuffer[] decryptedBufferList) {
        if (decryptedBufferList == null) {
            return;
        }
        if (decryptedBufferList.length == 0) {
            return;
        }
        this.getPreviousCallback().onData(decryptedBufferList);
    }

    public void onDataEncrypted(ByteBuffer plainData, ByteBuffer encryptedData) throws IOException {
        if (encryptedData.hasRemaining()) {
            this.pendingWriteMap.add(plainData, encryptedData);
            ByteBuffer[] buffers = new ByteBuffer[]{encryptedData};
            this.getSuccessor().write(buffers);
        }
    }

    private static final class PendingWriteMap {
        private Map<ByteBuffer, List<ByteBuffer>> plainEncryptedMapping = new IdentityHashMap<ByteBuffer, List<ByteBuffer>>();
        private Map<ByteBuffer, ByteBuffer> encryptedPlainMapping = new IdentityHashMap<ByteBuffer, ByteBuffer>();

        private PendingWriteMap() {
        }

        public synchronized void add(ByteBuffer plain, ByteBuffer encrypted) {
            if (plain.limit() > 0) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                if (encryptedList == null) {
                    encryptedList = new ArrayList<ByteBuffer>();
                    this.plainEncryptedMapping.put(plain, encryptedList);
                }
                encryptedList.add(encrypted);
                this.encryptedPlainMapping.put(encrypted, plain);
            }
        }

        public synchronized ByteBuffer getPlainIfWritten(ByteBuffer encrypted) {
            ByteBuffer plain = this.encryptedPlainMapping.remove(encrypted);
            if (plain != null) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                encryptedList.remove(encrypted);
                if (encryptedList.isEmpty()) {
                    this.plainEncryptedMapping.remove(plain);
                    return plain;
                }
            }
            return null;
        }

        public synchronized void clear() {
            this.plainEncryptedMapping.clear();
            this.encryptedPlainMapping.clear();
        }
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        public void onData(ByteBuffer[] data) {
            block5: {
                try {
                    if (IoActivateableSSLHandler.this.mode == Mode.OFF) {
                        IoActivateableSSLHandler.this.getPreviousCallback().onData(data);
                        break block5;
                    }
                    if (IoActivateableSSLHandler.this.mode == Mode.SSL) {
                        IoActivateableSSLHandler.this.readIncomingEncryptedData(data);
                        break block5;
                    }
                    assert (IoActivateableSSLHandler.this.mode == Mode.PLAIN_OUTGOING_SSL_INCOMING || IoActivateableSSLHandler.this.mode == Mode.PRE_SSL2);
                    IoActivateableSSLHandler.this.inNetDataQueue.append(data);
                    return;
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + IoActivateableSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        public void onConnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnect();
        }

        public void onWriteException(IOException ioException, ByteBuffer data) {
            IoActivateableSSLHandler.this.getPreviousCallback().onWriteException(ioException, data);
        }

        public void onWritten(ByteBuffer data) {
            ByteBuffer plainData = IoActivateableSSLHandler.this.pendingWriteMap.getPlainIfWritten(data);
            if (plainData != null) {
                IoActivateableSSLHandler.this.getPreviousCallback().onWritten(plainData);
            } else {
                IoActivateableSSLHandler.this.getPreviousCallback().onWritten(data);
            }
        }

        public void onDisconnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onDisconnect();
        }

        public void onConnectionAbnormalTerminated() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        OFF,
        PLAIN_OUTGOING_SSL_INCOMING,
        PRE_SSL2,
        SSL;

    }
}

