/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IBlockingConnection;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingConnection
implements IBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    private final ReadNotificationHandler handler = new ReadNotificationHandler();
    private final Object readGuard = new Object();
    private INonBlockingConnection delegee = null;
    private int receiveTimeout = Integer.MAX_VALUE;

    public BlockingConnection(String hostname, int port) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(String hostname, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, options, null, false);
    }

    public BlockingConnection(InetAddress address, int port) throws IOException {
        this(address, port, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), Integer.MAX_VALUE, options, sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), connectTimeoutMillis, options, sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn);
    }

    private BlockingConnection(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this.setUnderlyingConnection(new NonBlockingConnection(remoteAddress, connectTimeoutMillis, options, sslContext, sslOn, this.handler, (Executor)new SingleThreadedWorkerPool()));
    }

    public BlockingConnection(INonBlockingConnection delegee) throws IOException {
        this.setUnderlyingConnection(delegee);
        delegee.setHandler(this.handler);
    }

    private void setUnderlyingConnection(INonBlockingConnection delegee) {
        this.delegee = delegee;
    }

    final INonBlockingConnection getDelegee() {
        return this.delegee;
    }

    @Override
    public void setReceiveTimeoutMillis(int timeout) throws IOException {
        this.receiveTimeout = timeout;
        int soTimeout = (Integer)this.delegee.getOption("SOL_SOCKET.SO_TIMEOUT");
        if (timeout > soTimeout) {
            this.delegee.setOption("SOL_SOCKET.SO_TIMEOUT", timeout);
        }
    }

    @Override
    public final int getReceiveTimeoutMillis() throws IOException {
        return this.receiveTimeout;
    }

    @Override
    public int getMaxReadBufferThreshold() {
        return this.delegee.getMaxReadBufferThreshold();
    }

    @Override
    public void setMaxReadBufferThreshold(int size) {
        this.delegee.setMaxReadBufferThreshold(size);
    }

    @Override
    public final void setEncoding(String defaultEncoding) {
        this.delegee.setEncoding(defaultEncoding);
    }

    @Override
    public final String getEncoding() {
        return this.delegee.getEncoding();
    }

    @Override
    public final boolean isOpen() {
        return this.delegee.isOpen();
    }

    @Override
    public final void close() throws IOException {
        this.delegee.close();
    }

    @Override
    public final void flush() throws ClosedChannelException, IOException, SocketTimeoutException {
        this.delegee.flush();
    }

    @Override
    public String getId() {
        return this.delegee.getId();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.delegee.getRemoteAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.delegee.getRemotePort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.delegee.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.delegee.getLocalPort();
    }

    @Override
    public final int getPendingWriteDataSize() {
        return this.delegee.getPendingWriteDataSize();
    }

    @Override
    public final void suspendRead() throws IOException {
        this.delegee.suspendRead();
    }

    @Override
    public final void resumeRead() throws IOException {
        this.delegee.resumeRead();
    }

    @Override
    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.delegee.setFlushmode(flushMode);
    }

    @Override
    public IConnection.FlushMode getFlushmode() {
        return this.delegee.getFlushmode();
    }

    @Override
    public final void setOption(String name, Object value) throws IOException {
        this.delegee.setOption(name, value);
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.delegee.getOption(name);
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.delegee.getOptions();
    }

    @Override
    public final void setIdleTimeoutMillis(long timeoutInMillis) {
        this.delegee.setIdleTimeoutMillis(timeoutInMillis);
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.delegee.getIdleTimeoutMillis();
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.delegee.setConnectionTimeoutMillis(timeoutMillis);
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.delegee.getConnectionTimeoutMillis();
    }

    @Override
    public long getRemainingMillisToConnectionTimeout() {
        return this.delegee.getRemainingMillisToConnectionTimeout();
    }

    @Override
    public long getRemainingMillisToIdleTimeout() {
        return this.delegee.getRemainingMillisToIdleTimeout();
    }

    @Override
    public final void setAttachment(Object obj) {
        this.delegee.setAttachment(obj);
    }

    @Override
    public final Object getAttachment() {
        return this.delegee.getAttachment();
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        this.delegee.setAutoflush(autoflush);
    }

    @Override
    public final boolean isAutoflush() {
        return this.delegee.isAutoflush();
    }

    @Override
    public final void activateSecuredMode() throws IOException {
        this.delegee.activateSecuredMode();
    }

    @Override
    public boolean isSecure() {
        return this.delegee.isSecure();
    }

    @Override
    public final void markReadPosition() {
        this.delegee.markReadPosition();
    }

    @Override
    public final void markWritePosition() {
        this.delegee.markWritePosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int read(ByteBuffer buffer) throws IOException, ClosedChannelException {
        int size = buffer.remaining();
        if (size < 1) {
            return 0;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            do {
                int read;
                int availableSize;
                if ((availableSize = this.delegee.available()) > 0 && (read = this.delegee.read(buffer)) > 0) {
                    return read;
                }
                if (availableSize == -1) {
                    this.delegee.read(ByteBuffer.allocate(0));
                }
                if (!this.isOpen()) {
                    return -1;
                }
                this.waitForData(this.readGuard, remainingTime);
            } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    private void waitForData(Object readGuard, long maxWaittime) {
        try {
            readGuard.wait(maxWaittime);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte readByte() throws IOException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByte();
                }
                catch (BufferUnderflowException bue) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    this.waitForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final short readShort() throws IOException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readShort();
                }
                catch (BufferUnderflowException bue) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    this.waitForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int readInt() throws IOException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readInt();
                }
                catch (BufferUnderflowException bue) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    this.waitForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long readLong() throws IOException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readLong();
                }
                catch (BufferUnderflowException bue) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    this.waitForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double readDouble() throws IOException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readDouble();
                }
                catch (BufferUnderflowException bue) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    this.waitForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding());
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByteBufferByDelimiter(delimiter, encoding, maxLength);
                }
                catch (MaxReadSizeExceededException mre) {
                    throw mre;
                }
                catch (BufferUnderflowException bue) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    this.waitForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ByteBuffer[] readByteBufferByLength(int length) throws IOException, SocketTimeoutException {
        if (length <= 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByteBufferByLength(length);
                }
                catch (BufferUnderflowException bue) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    this.waitForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = start + (long)this.receiveTimeout - System.currentTimeMillis()) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter) throws IOException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding());
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
    }

    @Override
    public final byte[] readBytesByLength(int length) throws IOException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    @Override
    public final String readStringByDelimiter(String delimiter) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, String encoding) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toString(this.readByteBufferByDelimiter(delimiter, encoding, maxLength), encoding);
    }

    @Override
    public final String readStringByLength(int length) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByLength(length, this.getEncoding());
    }

    @Override
    public final String readStringByLength(int length, String encoding) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return DataConverter.toString(this.readByteBufferByLength(length), encoding);
    }

    @Override
    public final long transferTo(WritableByteChannel target, int length) throws IOException, SocketTimeoutException {
        ByteBuffer[] buffers;
        long written = 0L;
        for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    @Override
    public final boolean resetToWriteMark() {
        return this.delegee.resetToWriteMark();
    }

    @Override
    public final boolean resetToReadMark() {
        return this.delegee.resetToReadMark();
    }

    @Override
    public final void removeReadMark() {
        this.delegee.removeReadMark();
    }

    @Override
    public final void removeWriteMark() {
        this.delegee.removeWriteMark();
    }

    @Override
    public final int write(byte b) throws IOException, BufferOverflowException {
        return this.delegee.write(b);
    }

    @Override
    public final int write(byte ... bytes) throws IOException {
        return this.delegee.write(bytes);
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws IOException {
        return this.delegee.write(bytes, offset, length);
    }

    @Override
    public final int write(short s) throws IOException {
        return this.delegee.write(s);
    }

    @Override
    public final int write(int i) throws IOException {
        return this.delegee.write(i);
    }

    @Override
    public final int write(long l) throws IOException {
        return this.delegee.write(l);
    }

    @Override
    public final int write(double d) throws IOException {
        return this.delegee.write(d);
    }

    @Override
    public final int write(String message) throws IOException {
        return this.delegee.write(message);
    }

    @Override
    public final int write(String message, String encoding) throws IOException {
        return this.delegee.write(message, encoding);
    }

    public final long write(ArrayList<ByteBuffer> buffers) throws IOException {
        return this.delegee.write(buffers);
    }

    @Override
    public final long write(List<ByteBuffer> buffers) throws IOException {
        return this.delegee.write(buffers);
    }

    @Override
    public final long write(ByteBuffer[] buffers) throws IOException {
        return this.delegee.write(buffers);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegee.write(srcs, offset, length);
    }

    @Override
    public final int write(ByteBuffer buffer) throws IOException {
        return this.delegee.write(buffer);
    }

    @Override
    public final long transferFrom(ReadableByteChannel source) throws IOException {
        return this.delegee.transferFrom(source);
    }

    @Override
    public final long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException {
        return this.delegee.transferFrom(source, chunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReadDataInserted() {
        Object object = this.readGuard;
        synchronized (object) {
            this.readGuard.notifyAll();
        }
    }

    @Override
    public long transferFrom(FileChannel source) throws IOException {
        return this.delegee.transferFrom(source);
    }

    public String toString() {
        return this.delegee.toString();
    }

    @Execution(value=0)
    private final class ReadNotificationHandler
    implements IDataHandler,
    IDisconnectHandler,
    IConnectionTimeoutHandler,
    IIdleTimeoutHandler {
        private ReadNotificationHandler() {
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            BlockingConnection.this.onReadDataInserted();
            return true;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.onReadDataInserted();
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.onReadDataInserted();
            connection.close();
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.onReadDataInserted();
            connection.close();
            return true;
        }
    }

    private static final class SingleThreadedWorkerPool
    implements Executor {
        private SingleThreadedWorkerPool() {
        }

        public void execute(Runnable command) {
            command.run();
        }
    }
}

