/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;
import org.xrpl.xrpl4j.codec.binary.types.FieldWithValue;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FieldWithValue", generator="Immutables")
@Immutable
public final class ImmutableFieldWithValue<T>
implements FieldWithValue<T> {
    private final FieldInstance field;
    private final T value;

    private ImmutableFieldWithValue(FieldInstance field, T value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public FieldInstance field() {
        return this.field;
    }

    @Override
    public T value() {
        return this.value;
    }

    public final ImmutableFieldWithValue<T> withField(FieldInstance value) {
        if (this.field == value) {
            return this;
        }
        FieldInstance newValue = Objects.requireNonNull(value, "field");
        return new ImmutableFieldWithValue<T>(newValue, this.value);
    }

    public final ImmutableFieldWithValue<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "value");
        return new ImmutableFieldWithValue<T>(this.field, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldWithValue && this.equalTo((ImmutableFieldWithValue)another);
    }

    private boolean equalTo(ImmutableFieldWithValue<?> another) {
        return this.field.equals(another.field) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.field.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FieldWithValue").omitNullValues().add("field", (Object)this.field).add("value", this.value).toString();
    }

    public static <T> ImmutableFieldWithValue<T> copyOf(FieldWithValue<T> instance) {
        if (instance instanceof ImmutableFieldWithValue) {
            return (ImmutableFieldWithValue)instance;
        }
        return ImmutableFieldWithValue.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="FieldWithValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_FIELD = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private FieldInstance field;
        @Nullable
        private T value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(FieldWithValue<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.field(instance.field());
            this.value(instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> field(FieldInstance field) {
            this.field = Objects.requireNonNull(field, "field");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableFieldWithValue<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldWithValue(this.field, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("field");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build FieldWithValue, some of required attributes are not set " + attributes;
        }
    }
}

