package org.xrpl.xrpl4j.codec.binary.types;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;

/**
 * Immutable implementation of {@link FieldWithValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldWithValue.builder()}.
 */
@Generated(from = "FieldWithValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFieldWithValue<T> implements FieldWithValue<T> {
  private final FieldInstance field;
  private final T value;

  private ImmutableFieldWithValue(FieldInstance field, T value) {
    this.field = field;
    this.value = value;
  }

  /**
   * @return The value of the {@code field} attribute
   */
  @Override
  public FieldInstance field() {
    return field;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldWithValue#field() field} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for field
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldWithValue<T> withField(FieldInstance value) {
    if (this.field == value) return this;
    FieldInstance newValue = Objects.requireNonNull(value, "field");
    return new ImmutableFieldWithValue<>(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldWithValue#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldWithValue<T> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableFieldWithValue<>(this.field, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldWithValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldWithValue<?>
        && equalTo((ImmutableFieldWithValue<?>) another);
  }

  private boolean equalTo(ImmutableFieldWithValue<?> another) {
    return field.equals(another.field)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code field}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + field.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FieldWithValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FieldWithValue")
        .omitNullValues()
        .add("field", field)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FieldWithValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable FieldWithValue instance
   */
  public static <T> ImmutableFieldWithValue<T> copyOf(FieldWithValue<T> instance) {
    if (instance instanceof ImmutableFieldWithValue<?>) {
      return (ImmutableFieldWithValue<T>) instance;
    }
    return ImmutableFieldWithValue.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldWithValue ImmutableFieldWithValue}.
   * <pre>
   * ImmutableFieldWithValue.&amp;lt;T&amp;gt;builder()
   *    .field(org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance) // required {@link FieldWithValue#field() field}
   *    .value(T) // required {@link FieldWithValue#value() value}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableFieldWithValue builder
   */
  public static <T> ImmutableFieldWithValue.Builder<T> builder() {
    return new ImmutableFieldWithValue.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFieldWithValue ImmutableFieldWithValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldWithValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_FIELD = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable FieldInstance field;
    private @Nullable T value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldWithValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(FieldWithValue<T> instance) {
      Objects.requireNonNull(instance, "instance");
      field(instance.field());
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link FieldWithValue#field() field} attribute.
     * @param field The value for field 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> field(FieldInstance field) {
      this.field = Objects.requireNonNull(field, "field");
      initBits &= ~INIT_BIT_FIELD;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldWithValue#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldWithValue ImmutableFieldWithValue}.
     * @return An immutable instance of FieldWithValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldWithValue<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFieldWithValue<>(field, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIELD) != 0) attributes.add("field");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build FieldWithValue, some of required attributes are not set " + attributes;
    }
  }
}
