package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Amount}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAmount.builder()}.
 */
@Generated(from = "Amount", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAmount implements Amount {
  private final String currency;
  private final String value;
  private final String issuer;

  private ImmutableAmount(String currency, String value, String issuer) {
    this.currency = currency;
    this.value = value;
    this.issuer = issuer;
  }

  /**
   * @return The value of the {@code currency} attribute
   */
  @JsonProperty("currency")
  @Override
  public String currency() {
    return currency;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String value() {
    return value;
  }

  /**
   * @return The value of the {@code issuer} attribute
   */
  @JsonProperty("issuer")
  @Override
  public String issuer() {
    return issuer;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Amount#currency() currency} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for currency
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAmount withCurrency(String value) {
    String newValue = Objects.requireNonNull(value, "currency");
    if (this.currency.equals(newValue)) return this;
    return new ImmutableAmount(newValue, this.value, this.issuer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Amount#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAmount withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableAmount(this.currency, newValue, this.issuer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Amount#issuer() issuer} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issuer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAmount withIssuer(String value) {
    String newValue = Objects.requireNonNull(value, "issuer");
    if (this.issuer.equals(newValue)) return this;
    return new ImmutableAmount(this.currency, this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAmount} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAmount
        && equalTo((ImmutableAmount) another);
  }

  private boolean equalTo(ImmutableAmount another) {
    return currency.equals(another.currency)
        && value.equals(another.value)
        && issuer.equals(another.issuer);
  }

  /**
   * Computes a hash code from attributes: {@code currency}, {@code value}, {@code issuer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + currency.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + issuer.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Amount} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Amount")
        .omitNullValues()
        .add("currency", currency)
        .add("value", value)
        .add("issuer", issuer)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Amount", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Amount {
    @Nullable String currency;
    @Nullable String value;
    @Nullable String issuer;
    @JsonProperty("currency")
    public void setCurrency(String currency) {
      this.currency = currency;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("issuer")
    public void setIssuer(String issuer) {
      this.issuer = issuer;
    }
    @Override
    public String currency() { throw new UnsupportedOperationException(); }
    @Override
    public String value() { throw new UnsupportedOperationException(); }
    @Override
    public String issuer() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAmount fromJson(Json json) {
    ImmutableAmount.Builder builder = ImmutableAmount.builder();
    if (json.currency != null) {
      builder.currency(json.currency);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.issuer != null) {
      builder.issuer(json.issuer);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Amount} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Amount instance
   */
  public static ImmutableAmount copyOf(Amount instance) {
    if (instance instanceof ImmutableAmount) {
      return (ImmutableAmount) instance;
    }
    return ImmutableAmount.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAmount ImmutableAmount}.
   * <pre>
   * ImmutableAmount.builder()
   *    .currency(String) // required {@link Amount#currency() currency}
   *    .value(String) // required {@link Amount#value() value}
   *    .issuer(String) // required {@link Amount#issuer() issuer}
   *    .build();
   * </pre>
   * @return A new ImmutableAmount builder
   */
  public static ImmutableAmount.Builder builder() {
    return new ImmutableAmount.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAmount ImmutableAmount}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Amount", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CURRENCY = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private static final long INIT_BIT_ISSUER = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String currency;
    private @Nullable String value;
    private @Nullable String issuer;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Amount} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Amount instance) {
      Objects.requireNonNull(instance, "instance");
      currency(instance.currency());
      value(instance.value());
      issuer(instance.issuer());
      return this;
    }

    /**
     * Initializes the value for the {@link Amount#currency() currency} attribute.
     * @param currency The value for currency 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("currency")
    public final Builder currency(String currency) {
      this.currency = Objects.requireNonNull(currency, "currency");
      initBits &= ~INIT_BIT_CURRENCY;
      return this;
    }

    /**
     * Initializes the value for the {@link Amount#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link Amount#issuer() issuer} attribute.
     * @param issuer The value for issuer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("issuer")
    public final Builder issuer(String issuer) {
      this.issuer = Objects.requireNonNull(issuer, "issuer");
      initBits &= ~INIT_BIT_ISSUER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAmount ImmutableAmount}.
     * @return An immutable instance of Amount
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAmount build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAmount(currency, value, issuer);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CURRENCY) != 0) attributes.add("currency");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_ISSUER) != 0) attributes.add("issuer");
      return "Cannot build Amount, some of required attributes are not set " + attributes;
    }
  }
}
