package org.xrpl.xrpl4j.codec.binary.definitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Definitions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefinitions.builder()}.
 */
@Generated(from = "Definitions", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDefinitions implements Definitions {
  private final ImmutableMap<String, Integer> types;
  private final ImmutableList<List<JsonNode>> fields;
  private final ImmutableMap<String, Integer> ledgerEntryTypes;
  private final ImmutableMap<String, Integer> transactionTypes;
  private final ImmutableMap<String, Integer> transactionResults;

  private ImmutableDefinitions(
      ImmutableMap<String, Integer> types,
      ImmutableList<List<JsonNode>> fields,
      ImmutableMap<String, Integer> ledgerEntryTypes,
      ImmutableMap<String, Integer> transactionTypes,
      ImmutableMap<String, Integer> transactionResults) {
    this.types = types;
    this.fields = fields;
    this.ledgerEntryTypes = ledgerEntryTypes;
    this.transactionTypes = transactionTypes;
    this.transactionResults = transactionResults;
  }

  /**
   * Type definitions map (type name to ordinal value).
   * @return A {@link Map} of types.
   */
  @JsonProperty("TYPES")
  @Override
  public ImmutableMap<String, Integer> types() {
    return types;
  }

  /**
   * Fields definitions list.
   * @return {@link List} of type {@link List} of type {@link JsonNode} containing all field definitions.
   */
  @JsonProperty("FIELDS")
  @Override
  public ImmutableList<List<JsonNode>> fields() {
    return fields;
  }

  /**
   * Ledger types mappings (transaction type to ordinal value).
   * @return {@link Map} keyed by {@link String} with {@link Integer} values for all ledger entry types.
   */
  @JsonProperty("LEDGER_ENTRY_TYPES")
  @Override
  public ImmutableMap<String, Integer> ledgerEntryTypes() {
    return ledgerEntryTypes;
  }

  /**
   * Transaction types mappings (transaction type to ordinal value).
   * @return {@link Map} keyed by {@link String} with {@link Integer} values for all transaction types.
   */
  @JsonProperty("TRANSACTION_TYPES")
  @Override
  public ImmutableMap<String, Integer> transactionTypes() {
    return transactionTypes;
  }

  /**
   * Transaction results mappings (transaction result to ordinal value).
   * @return {@link Map} keyed by {@link String} with {@link Integer} values for all transaction results.
   */
  @JsonProperty("TRANSACTION_RESULTS")
  @Override
  public ImmutableMap<String, Integer> transactionResults() {
    return transactionResults;
  }

  /**
   * Copy the current immutable object by replacing the {@link Definitions#types() types} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the types map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefinitions withTypes(Map<String, ? extends Integer> entries) {
    if (this.types == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableDefinitions(newValue, this.fields, this.ledgerEntryTypes, this.transactionTypes, this.transactionResults);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Definitions#fields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableDefinitions withFields(List<JsonNode>... elements) {
    ImmutableList<List<JsonNode>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDefinitions(this.types, newValue, this.ledgerEntryTypes, this.transactionTypes, this.transactionResults);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Definitions#fields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefinitions withFields(Iterable<? extends List<JsonNode>> elements) {
    if (this.fields == elements) return this;
    ImmutableList<List<JsonNode>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDefinitions(this.types, newValue, this.ledgerEntryTypes, this.transactionTypes, this.transactionResults);
  }

  /**
   * Copy the current immutable object by replacing the {@link Definitions#ledgerEntryTypes() ledgerEntryTypes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the ledgerEntryTypes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefinitions withLedgerEntryTypes(Map<String, ? extends Integer> entries) {
    if (this.ledgerEntryTypes == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableDefinitions(this.types, this.fields, newValue, this.transactionTypes, this.transactionResults);
  }

  /**
   * Copy the current immutable object by replacing the {@link Definitions#transactionTypes() transactionTypes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the transactionTypes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefinitions withTransactionTypes(Map<String, ? extends Integer> entries) {
    if (this.transactionTypes == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableDefinitions(this.types, this.fields, this.ledgerEntryTypes, newValue, this.transactionResults);
  }

  /**
   * Copy the current immutable object by replacing the {@link Definitions#transactionResults() transactionResults} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the transactionResults map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefinitions withTransactionResults(Map<String, ? extends Integer> entries) {
    if (this.transactionResults == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableDefinitions(this.types, this.fields, this.ledgerEntryTypes, this.transactionTypes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefinitions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefinitions
        && equalTo((ImmutableDefinitions) another);
  }

  private boolean equalTo(ImmutableDefinitions another) {
    return types.equals(another.types)
        && fields.equals(another.fields)
        && ledgerEntryTypes.equals(another.ledgerEntryTypes)
        && transactionTypes.equals(another.transactionTypes)
        && transactionResults.equals(another.transactionResults);
  }

  /**
   * Computes a hash code from attributes: {@code types}, {@code fields}, {@code ledgerEntryTypes}, {@code transactionTypes}, {@code transactionResults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + types.hashCode();
    h += (h << 5) + fields.hashCode();
    h += (h << 5) + ledgerEntryTypes.hashCode();
    h += (h << 5) + transactionTypes.hashCode();
    h += (h << 5) + transactionResults.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Definitions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Definitions")
        .omitNullValues()
        .add("types", types)
        .add("fields", fields)
        .add("ledgerEntryTypes", ledgerEntryTypes)
        .add("transactionTypes", transactionTypes)
        .add("transactionResults", transactionResults)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Definitions", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Definitions {
    @Nullable Map<String, Integer> types = ImmutableMap.of();
    @Nullable List<List<JsonNode>> fields = ImmutableList.of();
    @Nullable Map<String, Integer> ledgerEntryTypes = ImmutableMap.of();
    @Nullable Map<String, Integer> transactionTypes = ImmutableMap.of();
    @Nullable Map<String, Integer> transactionResults = ImmutableMap.of();
    @JsonProperty("TYPES")
    public void setTypes(Map<String, Integer> types) {
      this.types = types;
    }
    @JsonProperty("FIELDS")
    public void setFields(List<List<JsonNode>> fields) {
      this.fields = fields;
    }
    @JsonProperty("LEDGER_ENTRY_TYPES")
    public void setLedgerEntryTypes(Map<String, Integer> ledgerEntryTypes) {
      this.ledgerEntryTypes = ledgerEntryTypes;
    }
    @JsonProperty("TRANSACTION_TYPES")
    public void setTransactionTypes(Map<String, Integer> transactionTypes) {
      this.transactionTypes = transactionTypes;
    }
    @JsonProperty("TRANSACTION_RESULTS")
    public void setTransactionResults(Map<String, Integer> transactionResults) {
      this.transactionResults = transactionResults;
    }
    @Override
    public Map<String, Integer> types() { throw new UnsupportedOperationException(); }
    @Override
    public List<List<JsonNode>> fields() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Integer> ledgerEntryTypes() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Integer> transactionTypes() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Integer> transactionResults() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDefinitions fromJson(Json json) {
    ImmutableDefinitions.Builder builder = ImmutableDefinitions.builder();
    if (json.types != null) {
      builder.putAllTypes(json.types);
    }
    if (json.fields != null) {
      builder.addAllFields(json.fields);
    }
    if (json.ledgerEntryTypes != null) {
      builder.putAllLedgerEntryTypes(json.ledgerEntryTypes);
    }
    if (json.transactionTypes != null) {
      builder.putAllTransactionTypes(json.transactionTypes);
    }
    if (json.transactionResults != null) {
      builder.putAllTransactionResults(json.transactionResults);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Definitions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Definitions instance
   */
  public static ImmutableDefinitions copyOf(Definitions instance) {
    if (instance instanceof ImmutableDefinitions) {
      return (ImmutableDefinitions) instance;
    }
    return ImmutableDefinitions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefinitions ImmutableDefinitions}.
   * <pre>
   * ImmutableDefinitions.builder()
   *    .putTypes|putAllTypes(String =&gt; int) // {@link Definitions#types() types} mappings
   *    .addFields|addAllFields(List&amp;lt;com.fasterxml.jackson.databind.JsonNode&amp;gt;) // {@link Definitions#fields() fields} elements
   *    .putLedgerEntryTypes|putAllLedgerEntryTypes(String =&gt; int) // {@link Definitions#ledgerEntryTypes() ledgerEntryTypes} mappings
   *    .putTransactionTypes|putAllTransactionTypes(String =&gt; int) // {@link Definitions#transactionTypes() transactionTypes} mappings
   *    .putTransactionResults|putAllTransactionResults(String =&gt; int) // {@link Definitions#transactionResults() transactionResults} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableDefinitions builder
   */
  public static ImmutableDefinitions.Builder builder() {
    return new ImmutableDefinitions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefinitions ImmutableDefinitions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Definitions", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, Integer> types = ImmutableMap.builder();
    private ImmutableList.Builder<List<JsonNode>> fields = ImmutableList.builder();
    private ImmutableMap.Builder<String, Integer> ledgerEntryTypes = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Integer> transactionTypes = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Integer> transactionResults = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Definitions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Definitions instance) {
      Objects.requireNonNull(instance, "instance");
      putAllTypes(instance.types());
      addAllFields(instance.fields());
      putAllLedgerEntryTypes(instance.ledgerEntryTypes());
      putAllTransactionTypes(instance.transactionTypes());
      putAllTransactionResults(instance.transactionResults());
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#types() types} map.
     * @param key The key in the types map
     * @param value The associated value in the types map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTypes(String key, int value) {
      this.types.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#types() types} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTypes(Map.Entry<String, ? extends Integer> entry) {
      this.types.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Definitions#types() types} map. Nulls are not permitted
     * @param entries The entries that will be added to the types map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TYPES")
    public final Builder types(Map<String, ? extends Integer> entries) {
      this.types = ImmutableMap.builder();
      return putAllTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Definitions#types() types} map. Nulls are not permitted
     * @param entries The entries that will be added to the types map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTypes(Map<String, ? extends Integer> entries) {
      this.types.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link Definitions#fields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(List<JsonNode> element) {
      this.fields.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Definitions#fields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addFields(List<JsonNode>... elements) {
      this.fields.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Definitions#fields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("FIELDS")
    public final Builder fields(Iterable<? extends List<JsonNode>> elements) {
      this.fields = ImmutableList.builder();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link Definitions#fields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFields(Iterable<? extends List<JsonNode>> elements) {
      this.fields.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#ledgerEntryTypes() ledgerEntryTypes} map.
     * @param key The key in the ledgerEntryTypes map
     * @param value The associated value in the ledgerEntryTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putLedgerEntryTypes(String key, int value) {
      this.ledgerEntryTypes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#ledgerEntryTypes() ledgerEntryTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putLedgerEntryTypes(Map.Entry<String, ? extends Integer> entry) {
      this.ledgerEntryTypes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Definitions#ledgerEntryTypes() ledgerEntryTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the ledgerEntryTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LEDGER_ENTRY_TYPES")
    public final Builder ledgerEntryTypes(Map<String, ? extends Integer> entries) {
      this.ledgerEntryTypes = ImmutableMap.builder();
      return putAllLedgerEntryTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Definitions#ledgerEntryTypes() ledgerEntryTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the ledgerEntryTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllLedgerEntryTypes(Map<String, ? extends Integer> entries) {
      this.ledgerEntryTypes.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#transactionTypes() transactionTypes} map.
     * @param key The key in the transactionTypes map
     * @param value The associated value in the transactionTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTransactionTypes(String key, int value) {
      this.transactionTypes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#transactionTypes() transactionTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTransactionTypes(Map.Entry<String, ? extends Integer> entry) {
      this.transactionTypes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Definitions#transactionTypes() transactionTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the transactionTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TRANSACTION_TYPES")
    public final Builder transactionTypes(Map<String, ? extends Integer> entries) {
      this.transactionTypes = ImmutableMap.builder();
      return putAllTransactionTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Definitions#transactionTypes() transactionTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the transactionTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTransactionTypes(Map<String, ? extends Integer> entries) {
      this.transactionTypes.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#transactionResults() transactionResults} map.
     * @param key The key in the transactionResults map
     * @param value The associated value in the transactionResults map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTransactionResults(String key, int value) {
      this.transactionResults.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Definitions#transactionResults() transactionResults} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTransactionResults(Map.Entry<String, ? extends Integer> entry) {
      this.transactionResults.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Definitions#transactionResults() transactionResults} map. Nulls are not permitted
     * @param entries The entries that will be added to the transactionResults map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TRANSACTION_RESULTS")
    public final Builder transactionResults(Map<String, ? extends Integer> entries) {
      this.transactionResults = ImmutableMap.builder();
      return putAllTransactionResults(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Definitions#transactionResults() transactionResults} map. Nulls are not permitted
     * @param entries The entries that will be added to the transactionResults map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTransactionResults(Map<String, ? extends Integer> entries) {
      this.transactionResults.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefinitions ImmutableDefinitions}.
     * @return An immutable instance of Definitions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefinitions build() {
      return new ImmutableDefinitions(
          types.build(),
          fields.build(),
          ledgerEntryTypes.build(),
          transactionTypes.build(),
          transactionResults.build());
    }
  }
}
