/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.definitions.DefinitionsService;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.serdes.BinarySerializer;
import org.xrpl.xrpl4j.codec.binary.types.FieldWithValue;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

public class STObjectType
extends SerializedType<STObjectType> {
    public static final String OBJECT_END_MARKER_HEX = "E1";
    private static final String OBJECT_END_MARKER = "ObjectEndMarker";
    private static final String ST_OBJECT = "STObject";
    private static final DefinitionsService definitionsService = DefinitionsService.getInstance();

    public STObjectType() {
        this(UnsignedByteArray.empty());
    }

    public STObjectType(UnsignedByteArray list) {
        super(list);
    }

    @Override
    public STObjectType fromParser(BinaryParser parser) {
        FieldInstance field;
        UnsignedByteArray byteArray = UnsignedByteArray.empty();
        BinarySerializer serializer = new BinarySerializer(byteArray);
        while (parser.hasMore() && !(field = parser.readField().orElseThrow(() -> new IllegalArgumentException("bad field encountered"))).name().equals(OBJECT_END_MARKER)) {
            SerializedType associatedValue = parser.readFieldValue(field);
            serializer.writeFieldAndValue(field, associatedValue);
            if (!field.type().equals(ST_OBJECT)) continue;
            serializer.put(OBJECT_END_MARKER_HEX);
        }
        return new STObjectType(byteArray);
    }

    @Override
    public STObjectType fromJson(JsonNode node) {
        UnsignedByteArray byteList = UnsignedByteArray.empty();
        BinarySerializer serializer = new BinarySerializer(byteList);
        ArrayList fields = new ArrayList();
        for (String fieldName : Lists.newArrayList((Iterator)node.fieldNames())) {
            JsonNode fieldNode = node.get(fieldName);
            definitionsService.getFieldInstance(fieldName).filter(FieldInstance::isSerialized).ifPresent(fieldInstance -> fields.add(FieldWithValue.builder().field((FieldInstance)fieldInstance).value(this.mapSpecializedValues(fieldName, fieldNode)).build()));
        }
        fields.stream().sorted().forEach(value -> {
            try {
                serializer.writeFieldAndValue(value.field(), (JsonNode)value.value());
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("invalid json", e);
            }
            if (value.field().type().equals(ST_OBJECT)) {
                serializer.put(OBJECT_END_MARKER_HEX);
            }
        });
        return new STObjectType(byteList);
    }

    private JsonNode mapSpecializedValues(String fieldName, JsonNode fieldNode) {
        return definitionsService.mapFieldSpecialization(fieldName, fieldNode.asText()).map(value -> new TextNode("" + value)).map(JsonNode.class::cast).orElse(fieldNode);
    }

    @Override
    public JsonNode toJson() {
        FieldInstance field;
        BinaryParser parser = new BinaryParser(this.toString());
        LinkedHashMap<String, JsonNode> objectMap = new LinkedHashMap<String, JsonNode>();
        while (parser.hasMore() && !(field = parser.readField().orElseThrow(() -> new IllegalArgumentException("bad field encountered"))).name().equals(OBJECT_END_MARKER)) {
            JsonNode value = parser.readFieldValue(field).toJson();
            JsonNode mapped = definitionsService.mapFieldRawValueToSpecialization(field.name(), value.asText()).map(TextNode::new).map(JsonNode.class::cast).orElse(value);
            objectMap.put(field.name(), mapped);
        }
        return new ObjectNode(BinaryCodecObjectMapperFactory.getObjectMapper().getNodeFactory(), objectMap);
    }
}

