/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.serdes.BinarySerializer;
import org.xrpl.xrpl4j.codec.binary.types.STObjectType;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

public class STArrayType
extends SerializedType<STArrayType> {
    public static final String ARRAY_END_MARKER_HEX = "F1";
    public static final String ARRAY_END_MARKER_NAME = "ArrayEndMarker";

    public STArrayType() {
        this(UnsignedByteArray.empty());
    }

    public STArrayType(UnsignedByteArray list) {
        super(list);
    }

    @Override
    public STArrayType fromParser(BinaryParser parser) {
        FieldInstance fieldInstance;
        UnsignedByteArray byteArray = UnsignedByteArray.empty();
        BinarySerializer serializer = new BinarySerializer(byteArray);
        while (parser.hasMore() && !(fieldInstance = parser.readField().orElseThrow(() -> new IllegalArgumentException("Parser should have had more fields but did not."))).name().equals(ARRAY_END_MARKER_NAME)) {
            SerializedType associatedValue = parser.readFieldValue(fieldInstance);
            serializer.writeFieldAndValue(fieldInstance, associatedValue);
            serializer.put("E1");
        }
        serializer.put(ARRAY_END_MARKER_HEX);
        return new STArrayType(byteArray);
    }

    @Override
    public STArrayType fromJson(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException("node is not an array");
        }
        UnsignedByteArray byteList = UnsignedByteArray.empty();
        BinarySerializer serializer = new BinarySerializer(byteList);
        Iterator nodeIterator = node.elements();
        while (nodeIterator.hasNext()) {
            JsonNode child = (JsonNode)nodeIterator.next();
            serializer.put(new STObjectType().fromJson(child).value().hexValue());
        }
        serializer.put(ARRAY_END_MARKER_HEX);
        return new STArrayType(byteList);
    }

    @Override
    public JsonNode toJson() {
        FieldInstance field;
        BinaryParser parser = new BinaryParser(this.toString());
        ArrayList<ObjectNode> values = new ArrayList<ObjectNode>();
        while (parser.hasMore() && !(field = parser.readField().orElseThrow(() -> new IllegalArgumentException("bad field encountered"))).name().equals(ARRAY_END_MARKER_NAME)) {
            STObjectType objectType = new STObjectType().fromParser(parser);
            ObjectNode child = new ObjectNode(BinaryCodecObjectMapperFactory.getObjectMapper().getNodeFactory(), (Map)ImmutableMap.of((Object)field.name(), (Object)objectType.toJson()));
            values.add(child);
        }
        return new ArrayNode(BinaryCodecObjectMapperFactory.getObjectMapper().getNodeFactory(), values);
    }
}

