/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj.error;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.internal.Failures;
import org.assertj.core.presentation.Representation;

abstract class ComparisonFailureErrorFactory
implements AssertionErrorFactory {
    private static Constructor<?> comparisonFailureConstructor;
    private static final String EXPECTED_BUT_WAS_MESSAGE = "%n%s%nExpected :<%s>%nActual   :<%s>%n";

    ComparisonFailureErrorFactory() {
    }

    abstract String getMessage();

    abstract String getExpected();

    abstract String getActual();

    public AssertionError newAssertionError(Description d, Representation representation) {
        String actual;
        String expected;
        String message = Description.emptyIfNull((Description)d).value() + this.getMessage();
        AssertionError assertionError = this.getComparisonFailureInstance(message, expected = this.getExpected(), actual = this.getActual());
        if (assertionError != null) {
            return assertionError;
        }
        String msg = String.format(EXPECTED_BUT_WAS_MESSAGE, message, expected, actual);
        return Failures.instance().failure(msg);
    }

    private AssertionError getComparisonFailureInstance(String message, String expected, String actual) {
        Constructor<?> constructor = ComparisonFailureErrorFactory.getComparisonFailureConstructor();
        if (constructor != null) {
            try {
                Object o = constructor.newInstance(message, expected, actual);
                if (o instanceof AssertionError) {
                    return (AssertionError)o;
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Constructor<?> getComparisonFailureConstructor() {
        if (comparisonFailureConstructor == null) {
            try {
                Class<?> targetType = Class.forName("org.junit.ComparisonFailure");
                comparisonFailureConstructor = targetType.getConstructor(String.class, String.class, String.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return comparisonFailureConstructor;
    }
}

